/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.crt.io;

import software.amazon.awssdk.crt.CrtResource;
import software.amazon.awssdk.crt.CrtRuntimeException;
import software.amazon.awssdk.crt.io.EventLoopGroup;

public class HostResolver
extends CrtResource {
    private static final int DEFAULT_MAX_ENTRIES = 8;
    private static int staticDefaultMaxEntries = 8;
    private static HostResolver staticDefaultResolver;

    public HostResolver(EventLoopGroup elg) throws CrtRuntimeException {
        this(elg, 8);
    }

    public HostResolver(EventLoopGroup elg, int maxEntries) throws CrtRuntimeException {
        this.acquireNativeHandle(HostResolver.hostResolverNew(elg.getNativeHandle(), maxEntries));
        this.addReferenceTo(elg);
    }

    @Override
    protected boolean canReleaseReferencesImmediately() {
        return true;
    }

    @Override
    protected void releaseNativeHandle() {
        if (!this.isNull()) {
            HostResolver.hostResolverRelease(this.getNativeHandle());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setStaticDefaultMaxEntries(int maxEntries) {
        Class<HostResolver> clazz = HostResolver.class;
        synchronized (HostResolver.class) {
            staticDefaultMaxEntries = maxEntries;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void closeStaticDefault() {
        Class<HostResolver> clazz = HostResolver.class;
        synchronized (HostResolver.class) {
            if (staticDefaultResolver != null) {
                staticDefaultResolver.close();
            }
            staticDefaultResolver = null;
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static HostResolver getOrCreateStaticDefault() {
        HostResolver resolver = null;
        Class<HostResolver> clazz = HostResolver.class;
        synchronized (HostResolver.class) {
            if (staticDefaultResolver == null) {
                staticDefaultResolver = new HostResolver(EventLoopGroup.getOrCreateStaticDefault(), staticDefaultMaxEntries);
            }
            resolver = staticDefaultResolver;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return resolver;
        }
    }

    private static native long hostResolverNew(long var0, int var2) throws CrtRuntimeException;

    private static native void hostResolverRelease(long var0);
}

