/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.snapshot;

import jakarta.json.stream.JsonGenerator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonData;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch._types.ErrorResponse;
import org.opensearch.client.opensearch._types.RequestBase;
import org.opensearch.client.opensearch._types.Time;
import org.opensearch.client.opensearch.snapshot.CreateSnapshotResponse;
import org.opensearch.client.transport.Endpoint;
import org.opensearch.client.transport.endpoints.SimpleEndpoint;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public final class CreateSnapshotRequest
extends RequestBase
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, CreateSnapshotRequest> {
    @Nullable
    private final Time clusterManagerTimeout;
    @Nonnull
    private final List<String> featureStates;
    @Nullable
    private final Boolean ignoreUnavailable;
    @Nullable
    private final Boolean includeGlobalState;
    @Nonnull
    private final List<String> indices;
    @Deprecated
    @Nullable
    private final Time masterTimeout;
    @Nonnull
    private final Map<String, JsonData> metadata;
    @Nullable
    private final Boolean partial;
    @Nonnull
    private final String repository;
    @Nonnull
    private final String snapshot;
    @Nullable
    private final Boolean waitForCompletion;
    public static final JsonpDeserializer<CreateSnapshotRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, CreateSnapshotRequest::setupCreateSnapshotRequestDeserializer);
    public static final Endpoint<CreateSnapshotRequest, CreateSnapshotResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<CreateSnapshotRequest, CreateSnapshotResponse>(request -> "PUT", request -> {
        StringBuilder buf = new StringBuilder();
        buf.append("/_snapshot/");
        SimpleEndpoint.pathEncode(request.repository, buf);
        buf.append("/");
        SimpleEndpoint.pathEncode(request.snapshot, buf);
        return buf.toString();
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        request.applyQueryParameters(params);
        return params;
    }, SimpleEndpoint.emptyMap(), true, CreateSnapshotResponse._DESERIALIZER);

    private CreateSnapshotRequest(Builder builder) {
        super(builder);
        this.clusterManagerTimeout = builder.clusterManagerTimeout;
        this.featureStates = ApiTypeHelper.unmodifiable(builder.featureStates);
        this.ignoreUnavailable = builder.ignoreUnavailable;
        this.includeGlobalState = builder.includeGlobalState;
        this.indices = ApiTypeHelper.unmodifiable(builder.indices);
        this.masterTimeout = builder.masterTimeout;
        this.metadata = ApiTypeHelper.unmodifiable(builder.metadata);
        this.partial = builder.partial;
        this.repository = ApiTypeHelper.requireNonNull(builder.repository, this, "repository");
        this.snapshot = ApiTypeHelper.requireNonNull(builder.snapshot, this, "snapshot");
        this.waitForCompletion = builder.waitForCompletion;
    }

    public static CreateSnapshotRequest of(Function<Builder, ObjectBuilder<CreateSnapshotRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Time clusterManagerTimeout() {
        return this.clusterManagerTimeout;
    }

    @Nonnull
    public final List<String> featureStates() {
        return this.featureStates;
    }

    @Nullable
    public final Boolean ignoreUnavailable() {
        return this.ignoreUnavailable;
    }

    @Nullable
    public final Boolean includeGlobalState() {
        return this.includeGlobalState;
    }

    @Nonnull
    public final List<String> indices() {
        return this.indices;
    }

    @Deprecated
    @Nullable
    public final Time masterTimeout() {
        return this.masterTimeout;
    }

    @Nonnull
    public final Map<String, JsonData> metadata() {
        return this.metadata;
    }

    @Nullable
    public final Boolean partial() {
        return this.partial;
    }

    @Nonnull
    public final String repository() {
        return this.repository;
    }

    @Nonnull
    public final String snapshot() {
        return this.snapshot;
    }

    @Nullable
    public final Boolean waitForCompletion() {
        return this.waitForCompletion;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.featureStates)) {
            generator.writeKey("feature_states");
            generator.writeStartArray();
            for (String string : this.featureStates) {
                generator.write(string);
            }
            generator.writeEnd();
        }
        if (this.ignoreUnavailable != null) {
            generator.writeKey("ignore_unavailable");
            generator.write(this.ignoreUnavailable.booleanValue());
        }
        if (this.includeGlobalState != null) {
            generator.writeKey("include_global_state");
            generator.write(this.includeGlobalState.booleanValue());
        }
        if (ApiTypeHelper.isDefined(this.indices)) {
            generator.writeKey("indices");
            generator.writeStartArray();
            for (String string : this.indices) {
                generator.write(string);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.metadata)) {
            generator.writeKey("metadata");
            generator.writeStartObject();
            for (Map.Entry entry : this.metadata.entrySet()) {
                generator.writeKey((String)entry.getKey());
                ((JsonData)entry.getValue()).serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.partial != null) {
            generator.writeKey("partial");
            generator.write(this.partial.booleanValue());
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupCreateSnapshotRequestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::featureStates, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "feature_states");
        op.add(Builder::ignoreUnavailable, JsonpDeserializer.booleanDeserializer(), "ignore_unavailable");
        op.add(Builder::includeGlobalState, JsonpDeserializer.booleanDeserializer(), "include_global_state");
        op.add(Builder::indices, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "indices");
        op.add(Builder::metadata, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "metadata");
        op.add(Builder::partial, JsonpDeserializer.booleanDeserializer(), "partial");
    }

    @Override
    protected void applyQueryParameters(@Nonnull Map<String, String> params) {
        super.applyQueryParameters(params);
        if (this.clusterManagerTimeout != null) {
            params.put("cluster_manager_timeout", this.clusterManagerTimeout._toJsonString());
        }
        if (this.masterTimeout != null) {
            params.put("master_timeout", this.masterTimeout._toJsonString());
        }
        if (this.waitForCompletion != null) {
            params.put("wait_for_completion", String.valueOf(this.waitForCompletion));
        }
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.clusterManagerTimeout);
        result = 31 * result + Objects.hashCode(this.featureStates);
        result = 31 * result + Objects.hashCode(this.ignoreUnavailable);
        result = 31 * result + Objects.hashCode(this.includeGlobalState);
        result = 31 * result + Objects.hashCode(this.indices);
        result = 31 * result + Objects.hashCode(this.masterTimeout);
        result = 31 * result + Objects.hashCode(this.metadata);
        result = 31 * result + Objects.hashCode(this.partial);
        result = 31 * result + this.repository.hashCode();
        result = 31 * result + this.snapshot.hashCode();
        result = 31 * result + Objects.hashCode(this.waitForCompletion);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateSnapshotRequest other = (CreateSnapshotRequest)o;
        return Objects.equals(this.clusterManagerTimeout, other.clusterManagerTimeout) && Objects.equals(this.featureStates, other.featureStates) && Objects.equals(this.ignoreUnavailable, other.ignoreUnavailable) && Objects.equals(this.includeGlobalState, other.includeGlobalState) && Objects.equals(this.indices, other.indices) && Objects.equals(this.masterTimeout, other.masterTimeout) && Objects.equals(this.metadata, other.metadata) && Objects.equals(this.partial, other.partial) && this.repository.equals(other.repository) && this.snapshot.equals(other.snapshot) && Objects.equals(this.waitForCompletion, other.waitForCompletion);
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements CopyableBuilder<Builder, CreateSnapshotRequest> {
        @Nullable
        private Time clusterManagerTimeout;
        @Nullable
        private List<String> featureStates;
        @Nullable
        private Boolean ignoreUnavailable;
        @Nullable
        private Boolean includeGlobalState;
        @Nullable
        private List<String> indices;
        @Nullable
        private Time masterTimeout;
        @Nullable
        private Map<String, JsonData> metadata;
        @Nullable
        private Boolean partial;
        private String repository;
        private String snapshot;
        @Nullable
        private Boolean waitForCompletion;

        public Builder() {
        }

        private Builder(CreateSnapshotRequest o) {
            super(o);
            this.clusterManagerTimeout = o.clusterManagerTimeout;
            this.featureStates = Builder._listCopy(o.featureStates);
            this.ignoreUnavailable = o.ignoreUnavailable;
            this.includeGlobalState = o.includeGlobalState;
            this.indices = Builder._listCopy(o.indices);
            this.masterTimeout = o.masterTimeout;
            this.metadata = Builder._mapCopy(o.metadata);
            this.partial = o.partial;
            this.repository = o.repository;
            this.snapshot = o.snapshot;
            this.waitForCompletion = o.waitForCompletion;
        }

        private Builder(Builder o) {
            super(o);
            this.clusterManagerTimeout = o.clusterManagerTimeout;
            this.featureStates = Builder._listCopy(o.featureStates);
            this.ignoreUnavailable = o.ignoreUnavailable;
            this.includeGlobalState = o.includeGlobalState;
            this.indices = Builder._listCopy(o.indices);
            this.masterTimeout = o.masterTimeout;
            this.metadata = Builder._mapCopy(o.metadata);
            this.partial = o.partial;
            this.repository = o.repository;
            this.snapshot = o.snapshot;
            this.waitForCompletion = o.waitForCompletion;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }

        @Nonnull
        public final Builder clusterManagerTimeout(@Nullable Time value) {
            this.clusterManagerTimeout = value;
            return this;
        }

        @Nonnull
        public final Builder clusterManagerTimeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.clusterManagerTimeout(fn.apply(new Time.Builder()).build());
        }

        @Nonnull
        public final Builder featureStates(List<String> list) {
            this.featureStates = Builder._listAddAll(this.featureStates, list);
            return this;
        }

        @Nonnull
        public final Builder featureStates(String value, String ... values) {
            this.featureStates = Builder._listAdd(this.featureStates, value, values);
            return this;
        }

        @Nonnull
        public final Builder ignoreUnavailable(@Nullable Boolean value) {
            this.ignoreUnavailable = value;
            return this;
        }

        @Nonnull
        public final Builder includeGlobalState(@Nullable Boolean value) {
            this.includeGlobalState = value;
            return this;
        }

        @Nonnull
        public final Builder indices(List<String> list) {
            this.indices = Builder._listAddAll(this.indices, list);
            return this;
        }

        @Nonnull
        public final Builder indices(String value, String ... values) {
            this.indices = Builder._listAdd(this.indices, value, values);
            return this;
        }

        @Deprecated
        @Nonnull
        public final Builder masterTimeout(@Nullable Time value) {
            this.masterTimeout = value;
            return this;
        }

        @Deprecated
        @Nonnull
        public final Builder masterTimeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.masterTimeout(fn.apply(new Time.Builder()).build());
        }

        @Nonnull
        public final Builder metadata(Map<String, JsonData> map) {
            this.metadata = Builder._mapPutAll(this.metadata, map);
            return this;
        }

        @Nonnull
        public final Builder metadata(String key, JsonData value) {
            this.metadata = Builder._mapPut(this.metadata, key, value);
            return this;
        }

        @Nonnull
        public final Builder partial(@Nullable Boolean value) {
            this.partial = value;
            return this;
        }

        @Nonnull
        public final Builder repository(String value) {
            this.repository = value;
            return this;
        }

        @Nonnull
        public final Builder snapshot(String value) {
            this.snapshot = value;
            return this;
        }

        @Nonnull
        public final Builder waitForCompletion(@Nullable Boolean value) {
            this.waitForCompletion = value;
            return this;
        }

        @Override
        @Nonnull
        public CreateSnapshotRequest build() {
            this._checkSingleUse();
            return new CreateSnapshotRequest(this);
        }
    }
}

