/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.snapshot;

import jakarta.json.stream.JsonGenerator;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch._types.ErrorResponse;
import org.opensearch.client.opensearch._types.RequestBase;
import org.opensearch.client.opensearch._types.Time;
import org.opensearch.client.opensearch.snapshot.CreateRepositoryResponse;
import org.opensearch.client.opensearch.snapshot.Repository;
import org.opensearch.client.opensearch.snapshot.RepositorySettings;
import org.opensearch.client.transport.Endpoint;
import org.opensearch.client.transport.endpoints.SimpleEndpoint;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public final class CreateRepositoryRequest
extends RequestBase
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, CreateRepositoryRequest> {
    @Nullable
    private final Time clusterManagerTimeout;
    @Deprecated
    @Nullable
    private final Time masterTimeout;
    @Nonnull
    private final String name;
    @Nullable
    private final Repository repository;
    @Nonnull
    private final RepositorySettings settings;
    @Nullable
    private final Time timeout;
    @Nonnull
    private final String type;
    @Nullable
    private final Boolean verify;
    public static final JsonpDeserializer<CreateRepositoryRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, CreateRepositoryRequest::setupCreateRepositoryRequestDeserializer);
    public static final Endpoint<CreateRepositoryRequest, CreateRepositoryResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<CreateRepositoryRequest, CreateRepositoryResponse>(request -> "PUT", request -> {
        StringBuilder buf = new StringBuilder();
        buf.append("/_snapshot/");
        SimpleEndpoint.pathEncode(request.name, buf);
        return buf.toString();
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        request.applyQueryParameters(params);
        return params;
    }, SimpleEndpoint.emptyMap(), true, CreateRepositoryResponse._DESERIALIZER);

    private CreateRepositoryRequest(Builder builder) {
        super(builder);
        this.clusterManagerTimeout = builder.clusterManagerTimeout;
        this.masterTimeout = builder.masterTimeout;
        this.name = ApiTypeHelper.requireNonNull(builder.name, this, "name");
        this.repository = builder.repository;
        this.settings = ApiTypeHelper.requireNonNull(builder.settings, this, "settings");
        this.timeout = builder.timeout;
        this.type = ApiTypeHelper.requireNonNull(builder.type, this, "type");
        this.verify = builder.verify;
    }

    public static CreateRepositoryRequest of(Function<Builder, ObjectBuilder<CreateRepositoryRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Time clusterManagerTimeout() {
        return this.clusterManagerTimeout;
    }

    @Deprecated
    @Nullable
    public final Time masterTimeout() {
        return this.masterTimeout;
    }

    @Nonnull
    public final String name() {
        return this.name;
    }

    @Nullable
    public final Repository repository() {
        return this.repository;
    }

    @Nonnull
    public final RepositorySettings settings() {
        return this.settings;
    }

    @Nullable
    public final Time timeout() {
        return this.timeout;
    }

    @Nonnull
    public final String type() {
        return this.type;
    }

    @Nullable
    public final Boolean verify() {
        return this.verify;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.repository != null) {
            generator.writeKey("repository");
            this.repository.serialize(generator, mapper);
        }
        generator.writeKey("settings");
        this.settings.serialize(generator, mapper);
        generator.writeKey("type");
        generator.write(this.type);
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupCreateRepositoryRequestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::repository, Repository._DESERIALIZER, "repository");
        op.add(Builder::settings, RepositorySettings._DESERIALIZER, "settings");
        op.add(Builder::type, JsonpDeserializer.stringDeserializer(), "type");
    }

    @Override
    protected void applyQueryParameters(@Nonnull Map<String, String> params) {
        super.applyQueryParameters(params);
        if (this.clusterManagerTimeout != null) {
            params.put("cluster_manager_timeout", this.clusterManagerTimeout._toJsonString());
        }
        if (this.masterTimeout != null) {
            params.put("master_timeout", this.masterTimeout._toJsonString());
        }
        if (this.timeout != null) {
            params.put("timeout", this.timeout._toJsonString());
        }
        if (this.verify != null) {
            params.put("verify", String.valueOf(this.verify));
        }
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.clusterManagerTimeout);
        result = 31 * result + Objects.hashCode(this.masterTimeout);
        result = 31 * result + this.name.hashCode();
        result = 31 * result + Objects.hashCode(this.repository);
        result = 31 * result + this.settings.hashCode();
        result = 31 * result + Objects.hashCode(this.timeout);
        result = 31 * result + this.type.hashCode();
        result = 31 * result + Objects.hashCode(this.verify);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateRepositoryRequest other = (CreateRepositoryRequest)o;
        return Objects.equals(this.clusterManagerTimeout, other.clusterManagerTimeout) && Objects.equals(this.masterTimeout, other.masterTimeout) && this.name.equals(other.name) && Objects.equals(this.repository, other.repository) && this.settings.equals(other.settings) && Objects.equals(this.timeout, other.timeout) && this.type.equals(other.type) && Objects.equals(this.verify, other.verify);
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements CopyableBuilder<Builder, CreateRepositoryRequest> {
        @Nullable
        private Time clusterManagerTimeout;
        @Nullable
        private Time masterTimeout;
        private String name;
        @Nullable
        private Repository repository;
        private RepositorySettings settings;
        @Nullable
        private Time timeout;
        private String type;
        @Nullable
        private Boolean verify;

        public Builder() {
        }

        private Builder(CreateRepositoryRequest o) {
            super(o);
            this.clusterManagerTimeout = o.clusterManagerTimeout;
            this.masterTimeout = o.masterTimeout;
            this.name = o.name;
            this.repository = o.repository;
            this.settings = o.settings;
            this.timeout = o.timeout;
            this.type = o.type;
            this.verify = o.verify;
        }

        private Builder(Builder o) {
            super(o);
            this.clusterManagerTimeout = o.clusterManagerTimeout;
            this.masterTimeout = o.masterTimeout;
            this.name = o.name;
            this.repository = o.repository;
            this.settings = o.settings;
            this.timeout = o.timeout;
            this.type = o.type;
            this.verify = o.verify;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }

        @Nonnull
        public final Builder clusterManagerTimeout(@Nullable Time value) {
            this.clusterManagerTimeout = value;
            return this;
        }

        @Nonnull
        public final Builder clusterManagerTimeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.clusterManagerTimeout(fn.apply(new Time.Builder()).build());
        }

        @Deprecated
        @Nonnull
        public final Builder masterTimeout(@Nullable Time value) {
            this.masterTimeout = value;
            return this;
        }

        @Deprecated
        @Nonnull
        public final Builder masterTimeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.masterTimeout(fn.apply(new Time.Builder()).build());
        }

        @Nonnull
        public final Builder name(String value) {
            this.name = value;
            return this;
        }

        @Nonnull
        public final Builder repository(@Nullable Repository value) {
            this.repository = value;
            return this;
        }

        @Nonnull
        public final Builder repository(Function<Repository.Builder, ObjectBuilder<Repository>> fn) {
            return this.repository(fn.apply(new Repository.Builder()).build());
        }

        @Nonnull
        public final Builder settings(RepositorySettings value) {
            this.settings = value;
            return this;
        }

        @Nonnull
        public final Builder settings(Function<RepositorySettings.Builder, ObjectBuilder<RepositorySettings>> fn) {
            return this.settings(fn.apply(new RepositorySettings.Builder()).build());
        }

        @Nonnull
        public final Builder timeout(@Nullable Time value) {
            this.timeout = value;
            return this;
        }

        @Nonnull
        public final Builder timeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.timeout(fn.apply(new Time.Builder()).build());
        }

        @Nonnull
        public final Builder type(String value) {
            this.type = value;
            return this;
        }

        @Nonnull
        public final Builder verify(@Nullable Boolean value) {
            this.verify = value;
            return this;
        }

        @Override
        @Nonnull
        public CreateRepositoryRequest build() {
            this._checkSingleUse();
            return new CreateRepositoryRequest(this);
        }
    }
}

