/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.nodes.stats;

import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch.nodes.stats.ScriptContextStats;
import org.opensearch.client.opensearch.nodes.stats.ScriptStats;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class ScriptCacheStats
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, ScriptCacheStats> {
    @Nonnull
    private final List<ScriptContextStats> contexts;
    @Nonnull
    private final ScriptStats sum;
    public static final JsonpDeserializer<ScriptCacheStats> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ScriptCacheStats::setupScriptCacheStatsDeserializer);

    private ScriptCacheStats(Builder builder) {
        this.contexts = ApiTypeHelper.unmodifiable(builder.contexts);
        this.sum = ApiTypeHelper.requireNonNull(builder.sum, this, "sum");
    }

    public static ScriptCacheStats of(Function<Builder, ObjectBuilder<ScriptCacheStats>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nonnull
    public final List<ScriptContextStats> contexts() {
        return this.contexts;
    }

    @Nonnull
    public final ScriptStats sum() {
        return this.sum;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.contexts)) {
            generator.writeKey("contexts");
            generator.writeStartArray();
            for (ScriptContextStats item0 : this.contexts) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        generator.writeKey("sum");
        this.sum.serialize(generator, mapper);
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupScriptCacheStatsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::contexts, JsonpDeserializer.arrayDeserializer(ScriptContextStats._DESERIALIZER), "contexts");
        op.add(Builder::sum, ScriptStats._DESERIALIZER, "sum");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.contexts);
        result = 31 * result + this.sum.hashCode();
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ScriptCacheStats other = (ScriptCacheStats)o;
        return Objects.equals(this.contexts, other.contexts) && this.sum.equals(other.sum);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, ScriptCacheStats> {
        @Nullable
        private List<ScriptContextStats> contexts;
        private ScriptStats sum;

        public Builder() {
        }

        private Builder(ScriptCacheStats o) {
            this.contexts = Builder._listCopy(o.contexts);
            this.sum = o.sum;
        }

        private Builder(Builder o) {
            this.contexts = Builder._listCopy(o.contexts);
            this.sum = o.sum;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder contexts(List<ScriptContextStats> list) {
            this.contexts = Builder._listAddAll(this.contexts, list);
            return this;
        }

        @Nonnull
        public final Builder contexts(ScriptContextStats value, ScriptContextStats ... values) {
            this.contexts = Builder._listAdd(this.contexts, value, values);
            return this;
        }

        @Nonnull
        public final Builder contexts(Function<ScriptContextStats.Builder, ObjectBuilder<ScriptContextStats>> fn) {
            return this.contexts(fn.apply(new ScriptContextStats.Builder()).build(), new ScriptContextStats[0]);
        }

        @Nonnull
        public final Builder sum(ScriptStats value) {
            this.sum = value;
            return this;
        }

        @Nonnull
        public final Builder sum(Function<ScriptStats.Builder, ObjectBuilder<ScriptStats>> fn) {
            return this.sum(fn.apply(new ScriptStats.Builder()).build());
        }

        @Override
        @Nonnull
        public ScriptCacheStats build() {
            this._checkSingleUse();
            return new ScriptCacheStats(this);
        }
    }
}

