/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.nodes.stats;

import jakarta.json.stream.JsonGenerator;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class OperatingSystemCpuStats
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, OperatingSystemCpuStats> {
    @Nonnull
    private final Map<String, Double> loadAverage;
    @Nullable
    private final Double percent;
    public static final JsonpDeserializer<OperatingSystemCpuStats> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, OperatingSystemCpuStats::setupOperatingSystemCpuStatsDeserializer);

    private OperatingSystemCpuStats(Builder builder) {
        this.loadAverage = ApiTypeHelper.unmodifiable(builder.loadAverage);
        this.percent = builder.percent;
    }

    public static OperatingSystemCpuStats of(Function<Builder, ObjectBuilder<OperatingSystemCpuStats>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nonnull
    public final Map<String, Double> loadAverage() {
        return this.loadAverage;
    }

    @Nullable
    public final Double percent() {
        return this.percent;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.loadAverage)) {
            generator.writeKey("load_average");
            generator.writeStartObject();
            for (Map.Entry<String, Double> item0 : this.loadAverage.entrySet()) {
                generator.writeKey(item0.getKey());
                generator.write(item0.getValue().doubleValue());
            }
            generator.writeEnd();
        }
        if (this.percent != null) {
            generator.writeKey("percent");
            generator.write(this.percent.doubleValue());
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupOperatingSystemCpuStatsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::loadAverage, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.doubleDeserializer()), "load_average");
        op.add(Builder::percent, JsonpDeserializer.doubleDeserializer(), "percent");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.loadAverage);
        result = 31 * result + Objects.hashCode(this.percent);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OperatingSystemCpuStats other = (OperatingSystemCpuStats)o;
        return Objects.equals(this.loadAverage, other.loadAverage) && Objects.equals(this.percent, other.percent);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, OperatingSystemCpuStats> {
        @Nullable
        private Map<String, Double> loadAverage;
        @Nullable
        private Double percent;

        public Builder() {
        }

        private Builder(OperatingSystemCpuStats o) {
            this.loadAverage = Builder._mapCopy(o.loadAverage);
            this.percent = o.percent;
        }

        private Builder(Builder o) {
            this.loadAverage = Builder._mapCopy(o.loadAverage);
            this.percent = o.percent;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder loadAverage(Map<String, Double> map) {
            this.loadAverage = Builder._mapPutAll(this.loadAverage, map);
            return this;
        }

        @Nonnull
        public final Builder loadAverage(String key, Double value) {
            this.loadAverage = Builder._mapPut(this.loadAverage, key, value);
            return this;
        }

        @Nonnull
        public final Builder percent(@Nullable Double value) {
            this.percent = value;
            return this;
        }

        @Override
        @Nonnull
        public OperatingSystemCpuStats build() {
            this._checkSingleUse();
            return new OperatingSystemCpuStats(this);
        }
    }
}

