/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.ml;

import jakarta.json.stream.JsonGenerator;
import java.util.HashMap;
import java.util.function.Function;
import javax.annotation.Nonnull;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch._types.ErrorResponse;
import org.opensearch.client.opensearch._types.RequestBase;
import org.opensearch.client.opensearch.ml.UploadChunkResponse;
import org.opensearch.client.transport.Endpoint;
import org.opensearch.client.transport.endpoints.SimpleEndpoint;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public final class UploadChunkRequest
extends RequestBase
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, UploadChunkRequest> {
    @Nonnull
    private final String chunk;
    private final long chunkNumber;
    @Nonnull
    private final String modelId;
    public static final JsonpDeserializer<UploadChunkRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, UploadChunkRequest::setupUploadChunkRequestDeserializer);
    public static final Endpoint<UploadChunkRequest, UploadChunkResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<UploadChunkRequest, UploadChunkResponse>(request -> "POST", request -> {
        StringBuilder buf = new StringBuilder();
        buf.append("/_plugins/_ml/models/");
        SimpleEndpoint.pathEncode(request.modelId, buf);
        buf.append("/upload_chunk/");
        SimpleEndpoint.pathEncode(String.valueOf(request.chunkNumber), buf);
        return buf.toString();
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        request.applyQueryParameters(params);
        return params;
    }, SimpleEndpoint.emptyMap(), true, UploadChunkResponse._DESERIALIZER);

    private UploadChunkRequest(Builder builder) {
        super(builder);
        this.chunk = ApiTypeHelper.requireNonNull(builder.chunk, this, "chunk");
        this.chunkNumber = ApiTypeHelper.requireNonNull(builder.chunkNumber, this, "chunkNumber");
        this.modelId = ApiTypeHelper.requireNonNull(builder.modelId, this, "modelId");
    }

    public static UploadChunkRequest of(Function<Builder, ObjectBuilder<UploadChunkRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nonnull
    public final String chunk() {
        return this.chunk;
    }

    public final long chunkNumber() {
        return this.chunkNumber;
    }

    @Nonnull
    public final String modelId() {
        return this.modelId;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("chunk");
        generator.write(this.chunk);
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupUploadChunkRequestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::chunk, JsonpDeserializer.stringDeserializer(), "chunk");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.chunk.hashCode();
        result = 31 * result + Long.hashCode(this.chunkNumber);
        result = 31 * result + this.modelId.hashCode();
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UploadChunkRequest other = (UploadChunkRequest)o;
        return this.chunk.equals(other.chunk) && this.chunkNumber == other.chunkNumber && this.modelId.equals(other.modelId);
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements CopyableBuilder<Builder, UploadChunkRequest> {
        private String chunk;
        private Long chunkNumber;
        private String modelId;

        public Builder() {
        }

        private Builder(UploadChunkRequest o) {
            super(o);
            this.chunk = o.chunk;
            this.chunkNumber = o.chunkNumber;
            this.modelId = o.modelId;
        }

        private Builder(Builder o) {
            super(o);
            this.chunk = o.chunk;
            this.chunkNumber = o.chunkNumber;
            this.modelId = o.modelId;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }

        @Nonnull
        public final Builder chunk(String value) {
            this.chunk = value;
            return this;
        }

        @Nonnull
        public final Builder chunkNumber(long value) {
            this.chunkNumber = value;
            return this;
        }

        @Nonnull
        public final Builder modelId(String value) {
            this.modelId = value;
            return this;
        }

        @Override
        @Nonnull
        public UploadChunkRequest build() {
            this._checkSingleUse();
            return new UploadChunkRequest(this);
        }
    }
}

