/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.ml;

import jakarta.json.stream.JsonGenerator;
import jakarta.json.stream.JsonParser;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonData;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch.ml.ToolAttributes;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class ToolItems
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, ToolItems> {
    @Nullable
    private final ToolAttributes attributes;
    @Nullable
    private final String description;
    @Nullable
    private final Boolean includeOutputInAgentResponse;
    @Nonnull
    private final Map<String, JsonData> metadata;
    @Nullable
    private final String name;
    @Nonnull
    private final Map<String, JsonData> parameters;
    @Nullable
    private final String type;
    public static final JsonpDeserializer<ToolItems> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ToolItems::setupToolItemsDeserializer);

    private ToolItems(Builder builder) {
        this.attributes = builder.attributes;
        this.description = builder.description;
        this.includeOutputInAgentResponse = builder.includeOutputInAgentResponse;
        this.metadata = ApiTypeHelper.unmodifiable(builder.metadata);
        this.name = builder.name;
        this.parameters = ApiTypeHelper.unmodifiable(builder.parameters);
        this.type = builder.type;
    }

    public static ToolItems of(Function<Builder, ObjectBuilder<ToolItems>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final ToolAttributes attributes() {
        return this.attributes;
    }

    @Nullable
    public final String description() {
        return this.description;
    }

    @Nullable
    public final Boolean includeOutputInAgentResponse() {
        return this.includeOutputInAgentResponse;
    }

    @Nonnull
    public final Map<String, JsonData> metadata() {
        return this.metadata;
    }

    @Nullable
    public final String name() {
        return this.name;
    }

    @Nonnull
    public final Map<String, JsonData> parameters() {
        return this.parameters;
    }

    @Nullable
    public final String type() {
        return this.type;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        for (Map.Entry<String, JsonData> item0 : this.metadata.entrySet()) {
            generator.writeKey(item0.getKey());
            item0.getValue().serialize(generator, mapper);
        }
        if (this.attributes != null) {
            generator.writeKey("attributes");
            this.attributes.serialize(generator, mapper);
        }
        if (this.description != null) {
            generator.writeKey("description");
            generator.write(this.description);
        }
        if (this.includeOutputInAgentResponse != null) {
            generator.writeKey("include_output_in_agent_response");
            generator.write(this.includeOutputInAgentResponse.booleanValue());
        }
        if (this.name != null) {
            generator.writeKey("name");
            generator.write(this.name);
        }
        if (ApiTypeHelper.isDefined(this.parameters)) {
            generator.writeKey("parameters");
            generator.writeStartObject();
            for (Map.Entry<String, JsonData> item0 : this.parameters.entrySet()) {
                generator.writeKey(item0.getKey());
                item0.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.type != null) {
            generator.writeKey("type");
            generator.write(this.type);
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupToolItemsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::attributes, ToolAttributes._DESERIALIZER, "attributes");
        op.add(Builder::description, JsonpDeserializer.stringDeserializer(), "description");
        op.add(Builder::includeOutputInAgentResponse, JsonpDeserializer.booleanDeserializer(), "include_output_in_agent_response");
        op.add(Builder::name, JsonpDeserializer.stringDeserializer(), "name");
        op.add(Builder::parameters, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "parameters");
        op.add(Builder::type, JsonpDeserializer.stringDeserializer(), "type");
        op.setUnknownFieldHandler((builder, name, parser, mapper) -> {
            if (((Builder)builder).metadata == null) {
                ((Builder)builder).metadata = new HashMap();
            }
            ((Builder)builder).metadata.put(name, JsonData._DESERIALIZER.deserialize((JsonParser)parser, (JsonpMapper)mapper));
        });
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.attributes);
        result = 31 * result + Objects.hashCode(this.description);
        result = 31 * result + Objects.hashCode(this.includeOutputInAgentResponse);
        result = 31 * result + Objects.hashCode(this.metadata);
        result = 31 * result + Objects.hashCode(this.name);
        result = 31 * result + Objects.hashCode(this.parameters);
        result = 31 * result + Objects.hashCode(this.type);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ToolItems other = (ToolItems)o;
        return Objects.equals(this.attributes, other.attributes) && Objects.equals(this.description, other.description) && Objects.equals(this.includeOutputInAgentResponse, other.includeOutputInAgentResponse) && Objects.equals(this.metadata, other.metadata) && Objects.equals(this.name, other.name) && Objects.equals(this.parameters, other.parameters) && Objects.equals(this.type, other.type);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, ToolItems> {
        @Nullable
        private ToolAttributes attributes;
        @Nullable
        private String description;
        @Nullable
        private Boolean includeOutputInAgentResponse;
        @Nullable
        private Map<String, JsonData> metadata;
        @Nullable
        private String name;
        @Nullable
        private Map<String, JsonData> parameters;
        @Nullable
        private String type;

        public Builder() {
        }

        private Builder(ToolItems o) {
            this.attributes = o.attributes;
            this.description = o.description;
            this.includeOutputInAgentResponse = o.includeOutputInAgentResponse;
            this.metadata = Builder._mapCopy(o.metadata);
            this.name = o.name;
            this.parameters = Builder._mapCopy(o.parameters);
            this.type = o.type;
        }

        private Builder(Builder o) {
            this.attributes = o.attributes;
            this.description = o.description;
            this.includeOutputInAgentResponse = o.includeOutputInAgentResponse;
            this.metadata = Builder._mapCopy(o.metadata);
            this.name = o.name;
            this.parameters = Builder._mapCopy(o.parameters);
            this.type = o.type;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder attributes(@Nullable ToolAttributes value) {
            this.attributes = value;
            return this;
        }

        @Nonnull
        public final Builder attributes(Function<ToolAttributes.Builder, ObjectBuilder<ToolAttributes>> fn) {
            return this.attributes(fn.apply(new ToolAttributes.Builder()).build());
        }

        @Nonnull
        public final Builder description(@Nullable String value) {
            this.description = value;
            return this;
        }

        @Nonnull
        public final Builder includeOutputInAgentResponse(@Nullable Boolean value) {
            this.includeOutputInAgentResponse = value;
            return this;
        }

        @Nonnull
        public final Builder metadata(Map<String, JsonData> map) {
            this.metadata = Builder._mapPutAll(this.metadata, map);
            return this;
        }

        @Nonnull
        public final Builder metadata(String key, JsonData value) {
            this.metadata = Builder._mapPut(this.metadata, key, value);
            return this;
        }

        @Nonnull
        public final Builder name(@Nullable String value) {
            this.name = value;
            return this;
        }

        @Nonnull
        public final Builder parameters(Map<String, JsonData> map) {
            this.parameters = Builder._mapPutAll(this.parameters, map);
            return this;
        }

        @Nonnull
        public final Builder parameters(String key, JsonData value) {
            this.parameters = Builder._mapPut(this.parameters, key, value);
            return this;
        }

        @Nonnull
        public final Builder type(@Nullable String value) {
            this.type = value;
            return this;
        }

        @Override
        @Nonnull
        public ToolItems build() {
            this._checkSingleUse();
            return new ToolItems(this);
        }
    }
}

