/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.indices.stats;

import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class ShardFileSizeInfo
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, ShardFileSizeInfo> {
    @Nullable
    private final Long averageSizeInBytes;
    @Nullable
    private final Long count;
    @Nonnull
    private final String description;
    @Nullable
    private final Long maxSizeInBytes;
    @Nullable
    private final Long minSizeInBytes;
    @Nullable
    private final String size;
    private final long sizeInBytes;
    public static final JsonpDeserializer<ShardFileSizeInfo> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ShardFileSizeInfo::setupShardFileSizeInfoDeserializer);

    private ShardFileSizeInfo(Builder builder) {
        this.averageSizeInBytes = builder.averageSizeInBytes;
        this.count = builder.count;
        this.description = ApiTypeHelper.requireNonNull(builder.description, this, "description");
        this.maxSizeInBytes = builder.maxSizeInBytes;
        this.minSizeInBytes = builder.minSizeInBytes;
        this.size = builder.size;
        this.sizeInBytes = ApiTypeHelper.requireNonNull(builder.sizeInBytes, this, "sizeInBytes");
    }

    public static ShardFileSizeInfo of(Function<Builder, ObjectBuilder<ShardFileSizeInfo>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Long averageSizeInBytes() {
        return this.averageSizeInBytes;
    }

    @Nullable
    public final Long count() {
        return this.count;
    }

    @Nonnull
    public final String description() {
        return this.description;
    }

    @Nullable
    public final Long maxSizeInBytes() {
        return this.maxSizeInBytes;
    }

    @Nullable
    public final Long minSizeInBytes() {
        return this.minSizeInBytes;
    }

    @Nullable
    public final String size() {
        return this.size;
    }

    public final long sizeInBytes() {
        return this.sizeInBytes;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.averageSizeInBytes != null) {
            generator.writeKey("average_size_in_bytes");
            generator.write(this.averageSizeInBytes.longValue());
        }
        if (this.count != null) {
            generator.writeKey("count");
            generator.write(this.count.longValue());
        }
        generator.writeKey("description");
        generator.write(this.description);
        if (this.maxSizeInBytes != null) {
            generator.writeKey("max_size_in_bytes");
            generator.write(this.maxSizeInBytes.longValue());
        }
        if (this.minSizeInBytes != null) {
            generator.writeKey("min_size_in_bytes");
            generator.write(this.minSizeInBytes.longValue());
        }
        if (this.size != null) {
            generator.writeKey("size");
            generator.write(this.size);
        }
        generator.writeKey("size_in_bytes");
        generator.write(this.sizeInBytes);
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupShardFileSizeInfoDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::averageSizeInBytes, JsonpDeserializer.longDeserializer(), "average_size_in_bytes");
        op.add(Builder::count, JsonpDeserializer.longDeserializer(), "count");
        op.add(Builder::description, JsonpDeserializer.stringDeserializer(), "description");
        op.add(Builder::maxSizeInBytes, JsonpDeserializer.longDeserializer(), "max_size_in_bytes");
        op.add(Builder::minSizeInBytes, JsonpDeserializer.longDeserializer(), "min_size_in_bytes");
        op.add(Builder::size, JsonpDeserializer.stringDeserializer(), "size");
        op.add(Builder::sizeInBytes, JsonpDeserializer.longDeserializer(), "size_in_bytes");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.averageSizeInBytes);
        result = 31 * result + Objects.hashCode(this.count);
        result = 31 * result + this.description.hashCode();
        result = 31 * result + Objects.hashCode(this.maxSizeInBytes);
        result = 31 * result + Objects.hashCode(this.minSizeInBytes);
        result = 31 * result + Objects.hashCode(this.size);
        result = 31 * result + Long.hashCode(this.sizeInBytes);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ShardFileSizeInfo other = (ShardFileSizeInfo)o;
        return Objects.equals(this.averageSizeInBytes, other.averageSizeInBytes) && Objects.equals(this.count, other.count) && this.description.equals(other.description) && Objects.equals(this.maxSizeInBytes, other.maxSizeInBytes) && Objects.equals(this.minSizeInBytes, other.minSizeInBytes) && Objects.equals(this.size, other.size) && this.sizeInBytes == other.sizeInBytes;
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, ShardFileSizeInfo> {
        @Nullable
        private Long averageSizeInBytes;
        @Nullable
        private Long count;
        private String description;
        @Nullable
        private Long maxSizeInBytes;
        @Nullable
        private Long minSizeInBytes;
        @Nullable
        private String size;
        private Long sizeInBytes;

        public Builder() {
        }

        private Builder(ShardFileSizeInfo o) {
            this.averageSizeInBytes = o.averageSizeInBytes;
            this.count = o.count;
            this.description = o.description;
            this.maxSizeInBytes = o.maxSizeInBytes;
            this.minSizeInBytes = o.minSizeInBytes;
            this.size = o.size;
            this.sizeInBytes = o.sizeInBytes;
        }

        private Builder(Builder o) {
            this.averageSizeInBytes = o.averageSizeInBytes;
            this.count = o.count;
            this.description = o.description;
            this.maxSizeInBytes = o.maxSizeInBytes;
            this.minSizeInBytes = o.minSizeInBytes;
            this.size = o.size;
            this.sizeInBytes = o.sizeInBytes;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder averageSizeInBytes(@Nullable Long value) {
            this.averageSizeInBytes = value;
            return this;
        }

        @Nonnull
        public final Builder count(@Nullable Long value) {
            this.count = value;
            return this;
        }

        @Nonnull
        public final Builder description(String value) {
            this.description = value;
            return this;
        }

        @Nonnull
        public final Builder maxSizeInBytes(@Nullable Long value) {
            this.maxSizeInBytes = value;
            return this;
        }

        @Nonnull
        public final Builder minSizeInBytes(@Nullable Long value) {
            this.minSizeInBytes = value;
            return this;
        }

        @Nonnull
        public final Builder size(@Nullable String value) {
            this.size = value;
            return this;
        }

        @Nonnull
        public final Builder sizeInBytes(long value) {
            this.sizeInBytes = value;
            return this;
        }

        @Override
        @Nonnull
        public ShardFileSizeInfo build() {
            this._checkSingleUse();
            return new ShardFileSizeInfo(this);
        }
    }
}

