/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.indices;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.opensearch._types.ErrorResponse;
import org.opensearch.client.opensearch._types.RequestBase;
import org.opensearch.client.opensearch.indices.RecoveryResponse;
import org.opensearch.client.transport.Endpoint;
import org.opensearch.client.transport.endpoints.SimpleEndpoint;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ToCopyableBuilder;

public final class RecoveryRequest
extends RequestBase
implements ToCopyableBuilder<Builder, RecoveryRequest> {
    @Nullable
    private final Boolean activeOnly;
    @Nullable
    private final Boolean detailed;
    @Nonnull
    private final List<String> index;
    public static final Endpoint<RecoveryRequest, RecoveryResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<RecoveryRequest, RecoveryResponse>(request -> "GET", request -> {
        boolean _index = true;
        boolean propsSet = false;
        if (ApiTypeHelper.isDefined(request.index())) {
            propsSet |= true;
        }
        if (!propsSet) {
            return "/_recovery";
        }
        if (propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/");
            SimpleEndpoint.pathEncode(String.join((CharSequence)",", request.index), buf);
            buf.append("/_recovery");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        request.applyQueryParameters(params);
        return params;
    }, SimpleEndpoint.emptyMap(), false, RecoveryResponse._DESERIALIZER);

    private RecoveryRequest(Builder builder) {
        super(builder);
        this.activeOnly = builder.activeOnly;
        this.detailed = builder.detailed;
        this.index = ApiTypeHelper.unmodifiable(builder.index);
    }

    public static RecoveryRequest of(Function<Builder, ObjectBuilder<RecoveryRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Boolean activeOnly() {
        return this.activeOnly;
    }

    @Nullable
    public final Boolean detailed() {
        return this.detailed;
    }

    @Nonnull
    public final List<String> index() {
        return this.index;
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    @Override
    protected void applyQueryParameters(@Nonnull Map<String, String> params) {
        super.applyQueryParameters(params);
        if (this.activeOnly != null) {
            params.put("active_only", String.valueOf(this.activeOnly));
        }
        if (this.detailed != null) {
            params.put("detailed", String.valueOf(this.detailed));
        }
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.activeOnly);
        result = 31 * result + Objects.hashCode(this.detailed);
        result = 31 * result + Objects.hashCode(this.index);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RecoveryRequest other = (RecoveryRequest)o;
        return Objects.equals(this.activeOnly, other.activeOnly) && Objects.equals(this.detailed, other.detailed) && Objects.equals(this.index, other.index);
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements CopyableBuilder<Builder, RecoveryRequest> {
        @Nullable
        private Boolean activeOnly;
        @Nullable
        private Boolean detailed;
        @Nullable
        private List<String> index;

        public Builder() {
        }

        private Builder(RecoveryRequest o) {
            super(o);
            this.activeOnly = o.activeOnly;
            this.detailed = o.detailed;
            this.index = Builder._listCopy(o.index);
        }

        private Builder(Builder o) {
            super(o);
            this.activeOnly = o.activeOnly;
            this.detailed = o.detailed;
            this.index = Builder._listCopy(o.index);
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }

        @Nonnull
        public final Builder activeOnly(@Nullable Boolean value) {
            this.activeOnly = value;
            return this;
        }

        @Nonnull
        public final Builder detailed(@Nullable Boolean value) {
            this.detailed = value;
            return this;
        }

        @Nonnull
        public final Builder index(List<String> list) {
            this.index = Builder._listAddAll(this.index, list);
            return this;
        }

        @Nonnull
        public final Builder index(String value, String ... values) {
            this.index = Builder._listAdd(this.index, value, values);
            return this;
        }

        @Override
        @Nonnull
        public RecoveryRequest build() {
            this._checkSingleUse();
            return new RecoveryRequest(this);
        }
    }
}

