/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.cluster.stats;

import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nonnull;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class ClusterShardMetrics
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, ClusterShardMetrics> {
    private final double avg;
    private final double max;
    private final double min;
    public static final JsonpDeserializer<ClusterShardMetrics> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ClusterShardMetrics::setupClusterShardMetricsDeserializer);

    private ClusterShardMetrics(Builder builder) {
        this.avg = ApiTypeHelper.requireNonNull(builder.avg, this, "avg");
        this.max = ApiTypeHelper.requireNonNull(builder.max, this, "max");
        this.min = ApiTypeHelper.requireNonNull(builder.min, this, "min");
    }

    public static ClusterShardMetrics of(Function<Builder, ObjectBuilder<ClusterShardMetrics>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final double avg() {
        return this.avg;
    }

    public final double max() {
        return this.max;
    }

    public final double min() {
        return this.min;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("avg");
        generator.write(this.avg);
        generator.writeKey("max");
        generator.write(this.max);
        generator.writeKey("min");
        generator.write(this.min);
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupClusterShardMetricsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::avg, JsonpDeserializer.doubleDeserializer(), "avg");
        op.add(Builder::max, JsonpDeserializer.doubleDeserializer(), "max");
        op.add(Builder::min, JsonpDeserializer.doubleDeserializer(), "min");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Double.hashCode(this.avg);
        result = 31 * result + Double.hashCode(this.max);
        result = 31 * result + Double.hashCode(this.min);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClusterShardMetrics other = (ClusterShardMetrics)o;
        return this.avg == other.avg && this.max == other.max && this.min == other.min;
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, ClusterShardMetrics> {
        private Double avg;
        private Double max;
        private Double min;

        public Builder() {
        }

        private Builder(ClusterShardMetrics o) {
            this.avg = o.avg;
            this.max = o.max;
            this.min = o.min;
        }

        private Builder(Builder o) {
            this.avg = o.avg;
            this.max = o.max;
            this.min = o.min;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder avg(double value) {
            this.avg = value;
            return this;
        }

        @Nonnull
        public final Builder max(double value) {
            this.max = value;
            return this;
        }

        @Nonnull
        public final Builder min(double value) {
            this.min = value;
            return this;
        }

        @Override
        @Nonnull
        public ClusterShardMetrics build() {
            this._checkSingleUse();
            return new ClusterShardMetrics(this);
        }
    }
}

