/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.query_dsl;

import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.query_dsl.Query;
import org.opensearch.client.opensearch._types.query_dsl.QueryBase;
import org.opensearch.client.opensearch._types.query_dsl.QueryVariant;
import org.opensearch.client.opensearch._types.query_dsl.SpanQuery;
import org.opensearch.client.opensearch._types.query_dsl.SpanQueryVariant;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class SpanNotQuery
extends QueryBase
implements QueryVariant,
SpanQueryVariant,
ToCopyableBuilder<Builder, SpanNotQuery> {
    @Nullable
    private final Integer dist;
    @Nonnull
    private final SpanQuery exclude;
    @Nonnull
    private final SpanQuery include;
    @Nullable
    private final Integer post;
    @Nullable
    private final Integer pre;
    public static final JsonpDeserializer<SpanNotQuery> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, SpanNotQuery::setupSpanNotQueryDeserializer);

    private SpanNotQuery(Builder builder) {
        super(builder);
        this.dist = builder.dist;
        this.exclude = ApiTypeHelper.requireNonNull(builder.exclude, this, "exclude");
        this.include = ApiTypeHelper.requireNonNull(builder.include, this, "include");
        this.post = builder.post;
        this.pre = builder.pre;
    }

    public static SpanNotQuery of(Function<Builder, ObjectBuilder<SpanNotQuery>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Query.Kind _queryKind() {
        return Query.Kind.SpanNot;
    }

    @Override
    public SpanQuery.Kind _spanQueryKind() {
        return SpanQuery.Kind.SpanNot;
    }

    @Nullable
    public final Integer dist() {
        return this.dist;
    }

    @Nonnull
    public final SpanQuery exclude() {
        return this.exclude;
    }

    @Nonnull
    public final SpanQuery include() {
        return this.include;
    }

    @Nullable
    public final Integer post() {
        return this.post;
    }

    @Nullable
    public final Integer pre() {
        return this.pre;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.dist != null) {
            generator.writeKey("dist");
            generator.write(this.dist.intValue());
        }
        generator.writeKey("exclude");
        this.exclude.serialize(generator, mapper);
        generator.writeKey("include");
        this.include.serialize(generator, mapper);
        if (this.post != null) {
            generator.writeKey("post");
            generator.write(this.post.intValue());
        }
        if (this.pre != null) {
            generator.writeKey("pre");
            generator.write(this.pre.intValue());
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupSpanNotQueryDeserializer(ObjectDeserializer<Builder> op) {
        SpanNotQuery.setupQueryBaseDeserializer(op);
        op.add(Builder::dist, JsonpDeserializer.integerDeserializer(), "dist");
        op.add(Builder::exclude, SpanQuery._DESERIALIZER, "exclude");
        op.add(Builder::include, SpanQuery._DESERIALIZER, "include");
        op.add(Builder::post, JsonpDeserializer.integerDeserializer(), "post");
        op.add(Builder::pre, JsonpDeserializer.integerDeserializer(), "pre");
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Objects.hashCode(this.dist);
        result = 31 * result + this.exclude.hashCode();
        result = 31 * result + this.include.hashCode();
        result = 31 * result + Objects.hashCode(this.post);
        result = 31 * result + Objects.hashCode(this.pre);
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SpanNotQuery other = (SpanNotQuery)o;
        return Objects.equals(this.dist, other.dist) && this.exclude.equals(other.exclude) && this.include.equals(other.include) && Objects.equals(this.post, other.post) && Objects.equals(this.pre, other.pre);
    }

    public static class Builder
    extends QueryBase.AbstractBuilder<Builder>
    implements CopyableBuilder<Builder, SpanNotQuery> {
        @Nullable
        private Integer dist;
        private SpanQuery exclude;
        private SpanQuery include;
        @Nullable
        private Integer post;
        @Nullable
        private Integer pre;

        public Builder() {
        }

        private Builder(SpanNotQuery o) {
            super(o);
            this.dist = o.dist;
            this.exclude = o.exclude;
            this.include = o.include;
            this.post = o.post;
            this.pre = o.pre;
        }

        private Builder(Builder o) {
            super(o);
            this.dist = o.dist;
            this.exclude = o.exclude;
            this.include = o.include;
            this.post = o.post;
            this.pre = o.pre;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }

        @Nonnull
        public final Builder dist(@Nullable Integer value) {
            this.dist = value;
            return this;
        }

        @Nonnull
        public final Builder exclude(SpanQuery value) {
            this.exclude = value;
            return this;
        }

        @Nonnull
        public final Builder exclude(Function<SpanQuery.Builder, ObjectBuilder<SpanQuery>> fn) {
            return this.exclude(fn.apply(new SpanQuery.Builder()).build());
        }

        @Nonnull
        public final Builder include(SpanQuery value) {
            this.include = value;
            return this;
        }

        @Nonnull
        public final Builder include(Function<SpanQuery.Builder, ObjectBuilder<SpanQuery>> fn) {
            return this.include(fn.apply(new SpanQuery.Builder()).build());
        }

        @Nonnull
        public final Builder post(@Nullable Integer value) {
            this.post = value;
            return this;
        }

        @Nonnull
        public final Builder pre(@Nullable Integer value) {
            this.pre = value;
            return this;
        }

        @Override
        @Nonnull
        public SpanNotQuery build() {
            this._checkSingleUse();
            return new SpanNotQuery(this);
        }
    }
}

