/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.analysis;

import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.analysis.TokenFilterBase;
import org.opensearch.client.opensearch._types.analysis.TokenFilterDefinition;
import org.opensearch.client.opensearch._types.analysis.TokenFilterDefinitionVariant;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class LowercaseTokenFilter
extends TokenFilterBase
implements TokenFilterDefinitionVariant,
ToCopyableBuilder<Builder, LowercaseTokenFilter> {
    @Nullable
    private final String language;
    public static final JsonpDeserializer<LowercaseTokenFilter> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, LowercaseTokenFilter::setupLowercaseTokenFilterDeserializer);

    private LowercaseTokenFilter(Builder builder) {
        super(builder);
        this.language = builder.language;
    }

    public static LowercaseTokenFilter of(Function<Builder, ObjectBuilder<LowercaseTokenFilter>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public TokenFilterDefinition.Kind _tokenFilterDefinitionKind() {
        return TokenFilterDefinition.Kind.Lowercase;
    }

    @Nullable
    public final String language() {
        return this.language;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "lowercase");
        super.serializeInternal(generator, mapper);
        if (this.language != null) {
            generator.writeKey("language");
            generator.write(this.language);
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupLowercaseTokenFilterDeserializer(ObjectDeserializer<Builder> op) {
        LowercaseTokenFilter.setupTokenFilterBaseDeserializer(op);
        op.add(Builder::language, JsonpDeserializer.stringDeserializer(), "language");
        op.ignore("type");
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Objects.hashCode(this.language);
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LowercaseTokenFilter other = (LowercaseTokenFilter)o;
        return Objects.equals(this.language, other.language);
    }

    public static class Builder
    extends TokenFilterBase.AbstractBuilder<Builder>
    implements CopyableBuilder<Builder, LowercaseTokenFilter> {
        @Nullable
        private String language;

        public Builder() {
        }

        private Builder(LowercaseTokenFilter o) {
            super(o);
            this.language = o.language;
        }

        private Builder(Builder o) {
            super(o);
            this.language = o.language;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }

        @Nonnull
        public final Builder language(@Nullable String value) {
            this.language = value;
            return this;
        }

        @Override
        @Nonnull
        public LowercaseTokenFilter build() {
            this._checkSingleUse();
            return new LowercaseTokenFilter(this);
        }
    }
}

