/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.aggregations;

import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.EmptyObject;
import org.opensearch.client.opensearch._types.aggregations.Aggregation;
import org.opensearch.client.opensearch._types.aggregations.AggregationVariant;
import org.opensearch.client.opensearch._types.aggregations.BucketAggregationBase;
import org.opensearch.client.opensearch._types.aggregations.ChiSquareHeuristic;
import org.opensearch.client.opensearch._types.aggregations.GoogleNormalizedDistanceHeuristic;
import org.opensearch.client.opensearch._types.aggregations.MutualInformationHeuristic;
import org.opensearch.client.opensearch._types.aggregations.PercentageScoreHeuristic;
import org.opensearch.client.opensearch._types.aggregations.ScriptedHeuristic;
import org.opensearch.client.opensearch._types.aggregations.TermsAggregationExecutionHint;
import org.opensearch.client.opensearch._types.aggregations.TermsExclude;
import org.opensearch.client.opensearch._types.aggregations.TermsInclude;
import org.opensearch.client.opensearch._types.query_dsl.Query;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class SignificantTextAggregation
extends BucketAggregationBase
implements AggregationVariant,
ToCopyableBuilder<Builder, SignificantTextAggregation> {
    @Nullable
    private final Query backgroundFilter;
    @Nullable
    private final ChiSquareHeuristic chiSquare;
    @Nullable
    private final TermsExclude exclude;
    @Nullable
    private final TermsAggregationExecutionHint executionHint;
    @Nullable
    private final String field;
    @Nullable
    private final Boolean filterDuplicateText;
    @Nullable
    private final GoogleNormalizedDistanceHeuristic gnd;
    @Nullable
    private final TermsInclude include;
    @Nullable
    private final EmptyObject jlh;
    @Nullable
    private final Long minDocCount;
    @Nullable
    private final MutualInformationHeuristic mutualInformation;
    @Nullable
    private final PercentageScoreHeuristic percentage;
    @Nullable
    private final ScriptedHeuristic scriptHeuristic;
    @Nullable
    private final Long shardMinDocCount;
    @Nullable
    private final Integer shardSize;
    @Nullable
    private final Integer size;
    @Nonnull
    private final List<String> sourceFields;
    public static final JsonpDeserializer<SignificantTextAggregation> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, SignificantTextAggregation::setupSignificantTextAggregationDeserializer);

    private SignificantTextAggregation(Builder builder) {
        super(builder);
        this.backgroundFilter = builder.backgroundFilter;
        this.chiSquare = builder.chiSquare;
        this.exclude = builder.exclude;
        this.executionHint = builder.executionHint;
        this.field = builder.field;
        this.filterDuplicateText = builder.filterDuplicateText;
        this.gnd = builder.gnd;
        this.include = builder.include;
        this.jlh = builder.jlh;
        this.minDocCount = builder.minDocCount;
        this.mutualInformation = builder.mutualInformation;
        this.percentage = builder.percentage;
        this.scriptHeuristic = builder.scriptHeuristic;
        this.shardMinDocCount = builder.shardMinDocCount;
        this.shardSize = builder.shardSize;
        this.size = builder.size;
        this.sourceFields = ApiTypeHelper.unmodifiable(builder.sourceFields);
    }

    public static SignificantTextAggregation of(Function<Builder, ObjectBuilder<SignificantTextAggregation>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Aggregation.Kind _aggregationKind() {
        return Aggregation.Kind.SignificantText;
    }

    @Nullable
    public final Query backgroundFilter() {
        return this.backgroundFilter;
    }

    @Nullable
    public final ChiSquareHeuristic chiSquare() {
        return this.chiSquare;
    }

    @Nullable
    public final TermsExclude exclude() {
        return this.exclude;
    }

    @Nullable
    public final TermsAggregationExecutionHint executionHint() {
        return this.executionHint;
    }

    @Nullable
    public final String field() {
        return this.field;
    }

    @Nullable
    public final Boolean filterDuplicateText() {
        return this.filterDuplicateText;
    }

    @Nullable
    public final GoogleNormalizedDistanceHeuristic gnd() {
        return this.gnd;
    }

    @Nullable
    public final TermsInclude include() {
        return this.include;
    }

    @Nullable
    public final EmptyObject jlh() {
        return this.jlh;
    }

    @Nullable
    public final Long minDocCount() {
        return this.minDocCount;
    }

    @Nullable
    public final MutualInformationHeuristic mutualInformation() {
        return this.mutualInformation;
    }

    @Nullable
    public final PercentageScoreHeuristic percentage() {
        return this.percentage;
    }

    @Nullable
    public final ScriptedHeuristic scriptHeuristic() {
        return this.scriptHeuristic;
    }

    @Nullable
    public final Long shardMinDocCount() {
        return this.shardMinDocCount;
    }

    @Nullable
    public final Integer shardSize() {
        return this.shardSize;
    }

    @Nullable
    public final Integer size() {
        return this.size;
    }

    @Nonnull
    public final List<String> sourceFields() {
        return this.sourceFields;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.backgroundFilter != null) {
            generator.writeKey("background_filter");
            this.backgroundFilter.serialize(generator, mapper);
        }
        if (this.chiSquare != null) {
            generator.writeKey("chi_square");
            this.chiSquare.serialize(generator, mapper);
        }
        if (this.exclude != null) {
            generator.writeKey("exclude");
            this.exclude.serialize(generator, mapper);
        }
        if (this.executionHint != null) {
            generator.writeKey("execution_hint");
            this.executionHint.serialize(generator, mapper);
        }
        if (this.field != null) {
            generator.writeKey("field");
            generator.write(this.field);
        }
        if (this.filterDuplicateText != null) {
            generator.writeKey("filter_duplicate_text");
            generator.write(this.filterDuplicateText.booleanValue());
        }
        if (this.gnd != null) {
            generator.writeKey("gnd");
            this.gnd.serialize(generator, mapper);
        }
        if (this.include != null) {
            generator.writeKey("include");
            this.include.serialize(generator, mapper);
        }
        if (this.jlh != null) {
            generator.writeKey("jlh");
            this.jlh.serialize(generator, mapper);
        }
        if (this.minDocCount != null) {
            generator.writeKey("min_doc_count");
            generator.write(this.minDocCount.longValue());
        }
        if (this.mutualInformation != null) {
            generator.writeKey("mutual_information");
            this.mutualInformation.serialize(generator, mapper);
        }
        if (this.percentage != null) {
            generator.writeKey("percentage");
            this.percentage.serialize(generator, mapper);
        }
        if (this.scriptHeuristic != null) {
            generator.writeKey("script_heuristic");
            this.scriptHeuristic.serialize(generator, mapper);
        }
        if (this.shardMinDocCount != null) {
            generator.writeKey("shard_min_doc_count");
            generator.write(this.shardMinDocCount.longValue());
        }
        if (this.shardSize != null) {
            generator.writeKey("shard_size");
            generator.write(this.shardSize.intValue());
        }
        if (this.size != null) {
            generator.writeKey("size");
            generator.write(this.size.intValue());
        }
        if (ApiTypeHelper.isDefined(this.sourceFields)) {
            generator.writeKey("source_fields");
            generator.writeStartArray();
            for (String item0 : this.sourceFields) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupSignificantTextAggregationDeserializer(ObjectDeserializer<Builder> op) {
        SignificantTextAggregation.setupBucketAggregationBaseDeserializer(op);
        op.add(Builder::backgroundFilter, Query._DESERIALIZER, "background_filter");
        op.add(Builder::chiSquare, ChiSquareHeuristic._DESERIALIZER, "chi_square");
        op.add(Builder::exclude, TermsExclude._DESERIALIZER, "exclude");
        op.add(Builder::executionHint, TermsAggregationExecutionHint._DESERIALIZER, "execution_hint");
        op.add(Builder::field, JsonpDeserializer.stringDeserializer(), "field");
        op.add(Builder::filterDuplicateText, JsonpDeserializer.booleanDeserializer(), "filter_duplicate_text");
        op.add(Builder::gnd, GoogleNormalizedDistanceHeuristic._DESERIALIZER, "gnd");
        op.add(Builder::include, TermsInclude._DESERIALIZER, "include");
        op.add(Builder::jlh, EmptyObject._DESERIALIZER, "jlh");
        op.add(Builder::minDocCount, JsonpDeserializer.longDeserializer(), "min_doc_count");
        op.add(Builder::mutualInformation, MutualInformationHeuristic._DESERIALIZER, "mutual_information");
        op.add(Builder::percentage, PercentageScoreHeuristic._DESERIALIZER, "percentage");
        op.add(Builder::scriptHeuristic, ScriptedHeuristic._DESERIALIZER, "script_heuristic");
        op.add(Builder::shardMinDocCount, JsonpDeserializer.longDeserializer(), "shard_min_doc_count");
        op.add(Builder::shardSize, JsonpDeserializer.integerDeserializer(), "shard_size");
        op.add(Builder::size, JsonpDeserializer.integerDeserializer(), "size");
        op.add(Builder::sourceFields, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "source_fields");
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Objects.hashCode(this.backgroundFilter);
        result = 31 * result + Objects.hashCode(this.chiSquare);
        result = 31 * result + Objects.hashCode(this.exclude);
        result = 31 * result + Objects.hashCode(this.executionHint);
        result = 31 * result + Objects.hashCode(this.field);
        result = 31 * result + Objects.hashCode(this.filterDuplicateText);
        result = 31 * result + Objects.hashCode(this.gnd);
        result = 31 * result + Objects.hashCode(this.include);
        result = 31 * result + Objects.hashCode(this.jlh);
        result = 31 * result + Objects.hashCode(this.minDocCount);
        result = 31 * result + Objects.hashCode(this.mutualInformation);
        result = 31 * result + Objects.hashCode(this.percentage);
        result = 31 * result + Objects.hashCode(this.scriptHeuristic);
        result = 31 * result + Objects.hashCode(this.shardMinDocCount);
        result = 31 * result + Objects.hashCode(this.shardSize);
        result = 31 * result + Objects.hashCode(this.size);
        result = 31 * result + Objects.hashCode(this.sourceFields);
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SignificantTextAggregation other = (SignificantTextAggregation)o;
        return Objects.equals(this.backgroundFilter, other.backgroundFilter) && Objects.equals(this.chiSquare, other.chiSquare) && Objects.equals(this.exclude, other.exclude) && Objects.equals(this.executionHint, other.executionHint) && Objects.equals(this.field, other.field) && Objects.equals(this.filterDuplicateText, other.filterDuplicateText) && Objects.equals(this.gnd, other.gnd) && Objects.equals(this.include, other.include) && Objects.equals(this.jlh, other.jlh) && Objects.equals(this.minDocCount, other.minDocCount) && Objects.equals(this.mutualInformation, other.mutualInformation) && Objects.equals(this.percentage, other.percentage) && Objects.equals(this.scriptHeuristic, other.scriptHeuristic) && Objects.equals(this.shardMinDocCount, other.shardMinDocCount) && Objects.equals(this.shardSize, other.shardSize) && Objects.equals(this.size, other.size) && Objects.equals(this.sourceFields, other.sourceFields);
    }

    public static class Builder
    extends BucketAggregationBase.AbstractBuilder<Builder>
    implements CopyableBuilder<Builder, SignificantTextAggregation> {
        @Nullable
        private Query backgroundFilter;
        @Nullable
        private ChiSquareHeuristic chiSquare;
        @Nullable
        private TermsExclude exclude;
        @Nullable
        private TermsAggregationExecutionHint executionHint;
        @Nullable
        private String field;
        @Nullable
        private Boolean filterDuplicateText;
        @Nullable
        private GoogleNormalizedDistanceHeuristic gnd;
        @Nullable
        private TermsInclude include;
        @Nullable
        private EmptyObject jlh;
        @Nullable
        private Long minDocCount;
        @Nullable
        private MutualInformationHeuristic mutualInformation;
        @Nullable
        private PercentageScoreHeuristic percentage;
        @Nullable
        private ScriptedHeuristic scriptHeuristic;
        @Nullable
        private Long shardMinDocCount;
        @Nullable
        private Integer shardSize;
        @Nullable
        private Integer size;
        @Nullable
        private List<String> sourceFields;

        public Builder() {
        }

        private Builder(SignificantTextAggregation o) {
            super(o);
            this.backgroundFilter = o.backgroundFilter;
            this.chiSquare = o.chiSquare;
            this.exclude = o.exclude;
            this.executionHint = o.executionHint;
            this.field = o.field;
            this.filterDuplicateText = o.filterDuplicateText;
            this.gnd = o.gnd;
            this.include = o.include;
            this.jlh = o.jlh;
            this.minDocCount = o.minDocCount;
            this.mutualInformation = o.mutualInformation;
            this.percentage = o.percentage;
            this.scriptHeuristic = o.scriptHeuristic;
            this.shardMinDocCount = o.shardMinDocCount;
            this.shardSize = o.shardSize;
            this.size = o.size;
            this.sourceFields = Builder._listCopy(o.sourceFields);
        }

        private Builder(Builder o) {
            super(o);
            this.backgroundFilter = o.backgroundFilter;
            this.chiSquare = o.chiSquare;
            this.exclude = o.exclude;
            this.executionHint = o.executionHint;
            this.field = o.field;
            this.filterDuplicateText = o.filterDuplicateText;
            this.gnd = o.gnd;
            this.include = o.include;
            this.jlh = o.jlh;
            this.minDocCount = o.minDocCount;
            this.mutualInformation = o.mutualInformation;
            this.percentage = o.percentage;
            this.scriptHeuristic = o.scriptHeuristic;
            this.shardMinDocCount = o.shardMinDocCount;
            this.shardSize = o.shardSize;
            this.size = o.size;
            this.sourceFields = Builder._listCopy(o.sourceFields);
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }

        @Nonnull
        public final Builder backgroundFilter(@Nullable Query value) {
            this.backgroundFilter = value;
            return this;
        }

        @Nonnull
        public final Builder backgroundFilter(Function<Query.Builder, ObjectBuilder<Query>> fn) {
            return this.backgroundFilter(fn.apply(new Query.Builder()).build());
        }

        @Nonnull
        public final Builder chiSquare(@Nullable ChiSquareHeuristic value) {
            this.chiSquare = value;
            return this;
        }

        @Nonnull
        public final Builder chiSquare(Function<ChiSquareHeuristic.Builder, ObjectBuilder<ChiSquareHeuristic>> fn) {
            return this.chiSquare(fn.apply(new ChiSquareHeuristic.Builder()).build());
        }

        @Nonnull
        public final Builder exclude(@Nullable TermsExclude value) {
            this.exclude = value;
            return this;
        }

        @Nonnull
        public final Builder exclude(Function<TermsExclude.Builder, ObjectBuilder<TermsExclude>> fn) {
            return this.exclude(fn.apply(new TermsExclude.Builder()).build());
        }

        @Nonnull
        public final Builder executionHint(@Nullable TermsAggregationExecutionHint value) {
            this.executionHint = value;
            return this;
        }

        @Nonnull
        public final Builder field(@Nullable String value) {
            this.field = value;
            return this;
        }

        @Nonnull
        public final Builder filterDuplicateText(@Nullable Boolean value) {
            this.filterDuplicateText = value;
            return this;
        }

        @Nonnull
        public final Builder gnd(@Nullable GoogleNormalizedDistanceHeuristic value) {
            this.gnd = value;
            return this;
        }

        @Nonnull
        public final Builder gnd(Function<GoogleNormalizedDistanceHeuristic.Builder, ObjectBuilder<GoogleNormalizedDistanceHeuristic>> fn) {
            return this.gnd(fn.apply(new GoogleNormalizedDistanceHeuristic.Builder()).build());
        }

        @Nonnull
        public final Builder include(@Nullable TermsInclude value) {
            this.include = value;
            return this;
        }

        @Nonnull
        public final Builder include(Function<TermsInclude.Builder, ObjectBuilder<TermsInclude>> fn) {
            return this.include(fn.apply(new TermsInclude.Builder()).build());
        }

        @Nonnull
        public final Builder jlh(@Nullable EmptyObject value) {
            this.jlh = value;
            return this;
        }

        @Nonnull
        public final Builder jlh(Function<EmptyObject.Builder, ObjectBuilder<EmptyObject>> fn) {
            return this.jlh(fn.apply(new EmptyObject.Builder()).build());
        }

        @Nonnull
        public final Builder minDocCount(@Nullable Long value) {
            this.minDocCount = value;
            return this;
        }

        @Nonnull
        public final Builder mutualInformation(@Nullable MutualInformationHeuristic value) {
            this.mutualInformation = value;
            return this;
        }

        @Nonnull
        public final Builder mutualInformation(Function<MutualInformationHeuristic.Builder, ObjectBuilder<MutualInformationHeuristic>> fn) {
            return this.mutualInformation(fn.apply(new MutualInformationHeuristic.Builder()).build());
        }

        @Nonnull
        public final Builder percentage(@Nullable PercentageScoreHeuristic value) {
            this.percentage = value;
            return this;
        }

        @Nonnull
        public final Builder percentage(Function<PercentageScoreHeuristic.Builder, ObjectBuilder<PercentageScoreHeuristic>> fn) {
            return this.percentage(fn.apply(new PercentageScoreHeuristic.Builder()).build());
        }

        @Nonnull
        public final Builder scriptHeuristic(@Nullable ScriptedHeuristic value) {
            this.scriptHeuristic = value;
            return this;
        }

        @Nonnull
        public final Builder scriptHeuristic(Function<ScriptedHeuristic.Builder, ObjectBuilder<ScriptedHeuristic>> fn) {
            return this.scriptHeuristic(fn.apply(new ScriptedHeuristic.Builder()).build());
        }

        @Nonnull
        public final Builder shardMinDocCount(@Nullable Long value) {
            this.shardMinDocCount = value;
            return this;
        }

        @Nonnull
        public final Builder shardSize(@Nullable Integer value) {
            this.shardSize = value;
            return this;
        }

        @Nonnull
        public final Builder size(@Nullable Integer value) {
            this.size = value;
            return this;
        }

        @Nonnull
        public final Builder sourceFields(List<String> list) {
            this.sourceFields = Builder._listAddAll(this.sourceFields, list);
            return this;
        }

        @Nonnull
        public final Builder sourceFields(String value, String ... values) {
            this.sourceFields = Builder._listAdd(this.sourceFields, value, values);
            return this;
        }

        @Override
        @Nonnull
        public SignificantTextAggregation build() {
            this._checkSingleUse();
            return new SignificantTextAggregation(this);
        }
    }
}

