/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.aggregations;

import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class HoltLinearModelSettings
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, HoltLinearModelSettings> {
    @Nullable
    private final Float alpha;
    @Nullable
    private final Float beta;
    public static final JsonpDeserializer<HoltLinearModelSettings> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, HoltLinearModelSettings::setupHoltLinearModelSettingsDeserializer);

    private HoltLinearModelSettings(Builder builder) {
        this.alpha = builder.alpha;
        this.beta = builder.beta;
    }

    public static HoltLinearModelSettings of(Function<Builder, ObjectBuilder<HoltLinearModelSettings>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Float alpha() {
        return this.alpha;
    }

    @Nullable
    public final Float beta() {
        return this.beta;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.alpha != null) {
            generator.writeKey("alpha");
            generator.write((double)this.alpha.floatValue());
        }
        if (this.beta != null) {
            generator.writeKey("beta");
            generator.write((double)this.beta.floatValue());
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupHoltLinearModelSettingsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::alpha, JsonpDeserializer.floatDeserializer(), "alpha");
        op.add(Builder::beta, JsonpDeserializer.floatDeserializer(), "beta");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.alpha);
        result = 31 * result + Objects.hashCode(this.beta);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HoltLinearModelSettings other = (HoltLinearModelSettings)o;
        return Objects.equals(this.alpha, other.alpha) && Objects.equals(this.beta, other.beta);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, HoltLinearModelSettings> {
        @Nullable
        private Float alpha;
        @Nullable
        private Float beta;

        public Builder() {
        }

        private Builder(HoltLinearModelSettings o) {
            this.alpha = o.alpha;
            this.beta = o.beta;
        }

        private Builder(Builder o) {
            this.alpha = o.alpha;
            this.beta = o.beta;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder alpha(@Nullable Float value) {
            this.alpha = value;
            return this;
        }

        @Nonnull
        public final Builder beta(@Nullable Float value) {
            this.beta = value;
            return this;
        }

        @Override
        @Nonnull
        public HoltLinearModelSettings build() {
            this._checkSingleUse();
            return new HoltLinearModelSettings(this);
        }
    }
}

