/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types;

import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch._types.NestedSortValue;
import org.opensearch.client.opensearch._types.Script;
import org.opensearch.client.opensearch._types.ScriptSortType;
import org.opensearch.client.opensearch._types.SortMode;
import org.opensearch.client.opensearch._types.SortOptions;
import org.opensearch.client.opensearch._types.SortOptionsVariant;
import org.opensearch.client.opensearch._types.SortOrder;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class ScriptSort
implements SortOptionsVariant,
PlainJsonSerializable,
ToCopyableBuilder<Builder, ScriptSort> {
    @Nullable
    private final SortMode mode;
    @Nullable
    private final NestedSortValue nested;
    @Nullable
    private final SortOrder order;
    @Nonnull
    private final Script script;
    @Nullable
    private final ScriptSortType type;
    public static final JsonpDeserializer<ScriptSort> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ScriptSort::setupScriptSortDeserializer);

    private ScriptSort(Builder builder) {
        this.mode = builder.mode;
        this.nested = builder.nested;
        this.order = builder.order;
        this.script = ApiTypeHelper.requireNonNull(builder.script, this, "script");
        this.type = builder.type;
    }

    public static ScriptSort of(Function<Builder, ObjectBuilder<ScriptSort>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public SortOptions.Kind _sortOptionsKind() {
        return SortOptions.Kind.Script;
    }

    @Nullable
    public final SortMode mode() {
        return this.mode;
    }

    @Nullable
    public final NestedSortValue nested() {
        return this.nested;
    }

    @Nullable
    public final SortOrder order() {
        return this.order;
    }

    @Nonnull
    public final Script script() {
        return this.script;
    }

    @Nullable
    public final ScriptSortType type() {
        return this.type;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.mode != null) {
            generator.writeKey("mode");
            this.mode.serialize(generator, mapper);
        }
        if (this.nested != null) {
            generator.writeKey("nested");
            this.nested.serialize(generator, mapper);
        }
        if (this.order != null) {
            generator.writeKey("order");
            this.order.serialize(generator, mapper);
        }
        generator.writeKey("script");
        this.script.serialize(generator, mapper);
        if (this.type != null) {
            generator.writeKey("type");
            this.type.serialize(generator, mapper);
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupScriptSortDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::mode, SortMode._DESERIALIZER, "mode");
        op.add(Builder::nested, NestedSortValue._DESERIALIZER, "nested");
        op.add(Builder::order, SortOrder._DESERIALIZER, "order");
        op.add(Builder::script, Script._DESERIALIZER, "script");
        op.add(Builder::type, ScriptSortType._DESERIALIZER, "type");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.mode);
        result = 31 * result + Objects.hashCode(this.nested);
        result = 31 * result + Objects.hashCode(this.order);
        result = 31 * result + this.script.hashCode();
        result = 31 * result + Objects.hashCode(this.type);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ScriptSort other = (ScriptSort)o;
        return Objects.equals(this.mode, other.mode) && Objects.equals(this.nested, other.nested) && Objects.equals(this.order, other.order) && this.script.equals(other.script) && Objects.equals(this.type, other.type);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, ScriptSort> {
        @Nullable
        private SortMode mode;
        @Nullable
        private NestedSortValue nested;
        @Nullable
        private SortOrder order;
        private Script script;
        @Nullable
        private ScriptSortType type;

        public Builder() {
        }

        private Builder(ScriptSort o) {
            this.mode = o.mode;
            this.nested = o.nested;
            this.order = o.order;
            this.script = o.script;
            this.type = o.type;
        }

        private Builder(Builder o) {
            this.mode = o.mode;
            this.nested = o.nested;
            this.order = o.order;
            this.script = o.script;
            this.type = o.type;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder mode(@Nullable SortMode value) {
            this.mode = value;
            return this;
        }

        @Nonnull
        public final Builder nested(@Nullable NestedSortValue value) {
            this.nested = value;
            return this;
        }

        @Nonnull
        public final Builder nested(Function<NestedSortValue.Builder, ObjectBuilder<NestedSortValue>> fn) {
            return this.nested(fn.apply(new NestedSortValue.Builder()).build());
        }

        @Nonnull
        public final Builder order(@Nullable SortOrder value) {
            this.order = value;
            return this;
        }

        @Nonnull
        public final Builder script(Script value) {
            this.script = value;
            return this;
        }

        @Nonnull
        public final Builder script(Function<Script.Builder, ObjectBuilder<Script>> fn) {
            return this.script(fn.apply(new Script.Builder()).build());
        }

        @Nonnull
        public final Builder type(@Nullable ScriptSortType value) {
            this.type = value;
            return this;
        }

        @Override
        @Nonnull
        public ScriptSort build() {
            this._checkSingleUse();
            return new ScriptSort(this);
        }
    }
}

