/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.dynamodb.DynamoDbAsyncClient;
import software.amazon.awssdk.services.dynamodb.internal.UserAgentUtils;
import software.amazon.awssdk.services.dynamodb.model.ListContributorInsightsRequest;
import software.amazon.awssdk.services.dynamodb.model.ListContributorInsightsResponse;

public class ListContributorInsightsPublisher
implements SdkPublisher<ListContributorInsightsResponse> {
    private final DynamoDbAsyncClient client;
    private final ListContributorInsightsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListContributorInsightsPublisher(DynamoDbAsyncClient client, ListContributorInsightsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListContributorInsightsPublisher(DynamoDbAsyncClient client, ListContributorInsightsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListContributorInsightsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListContributorInsightsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListContributorInsightsResponseFetcher
    implements AsyncPageFetcher<ListContributorInsightsResponse> {
        private ListContributorInsightsResponseFetcher() {
        }

        public boolean hasNextPage(ListContributorInsightsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListContributorInsightsResponse> nextPage(ListContributorInsightsResponse previousPage) {
            if (previousPage == null) {
                return ListContributorInsightsPublisher.this.client.listContributorInsights(ListContributorInsightsPublisher.this.firstRequest);
            }
            return ListContributorInsightsPublisher.this.client.listContributorInsights((ListContributorInsightsRequest)((Object)ListContributorInsightsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

