/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.common.transport.forward;

import java.io.IOException;
import java.util.Arrays;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.Version;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.ml.common.CommonValue;
import org.opensearch.ml.common.MLTask;
import org.opensearch.ml.common.input.MLInput;
import org.opensearch.ml.common.transport.forward.MLForwardRequestType;
import org.opensearch.ml.common.transport.register.MLRegisterModelInput;

public class MLForwardInput
implements Writeable {
    @Generated
    private static final Logger log = LogManager.getLogger(MLForwardInput.class);
    private String taskId;
    private String modelId;
    private String tenantId;
    private String workerNodeId;
    private MLForwardRequestType requestType;
    private MLTask mlTask;
    MLInput modelInput;
    private String error;
    private String[] workerNodes;
    private MLRegisterModelInput registerModelInput;

    public MLForwardInput(String taskId, String modelId, String tenantId, String workerNodeId, MLForwardRequestType requestType, MLTask mlTask, MLInput modelInput, String error, String[] workerNodes, MLRegisterModelInput registerModelInput) {
        this.taskId = taskId;
        this.modelId = modelId;
        this.tenantId = tenantId;
        this.workerNodeId = workerNodeId;
        this.requestType = requestType;
        this.mlTask = mlTask;
        this.modelInput = modelInput;
        this.error = error;
        this.workerNodes = workerNodes;
        this.registerModelInput = registerModelInput;
    }

    public MLForwardInput(StreamInput in) throws IOException {
        Version streamInputVersion = in.getVersion();
        this.taskId = in.readOptionalString();
        this.modelId = in.readOptionalString();
        this.workerNodeId = in.readOptionalString();
        this.requestType = (MLForwardRequestType)in.readEnum(MLForwardRequestType.class);
        if (in.readBoolean()) {
            this.mlTask = new MLTask(in);
        }
        if (in.readBoolean()) {
            this.modelInput = new MLInput(in);
        }
        this.error = in.readOptionalString();
        this.workerNodes = in.readOptionalStringArray();
        if (in.readBoolean()) {
            this.registerModelInput = new MLRegisterModelInput(in);
        }
        this.tenantId = streamInputVersion.onOrAfter(CommonValue.VERSION_2_19_0) ? in.readOptionalString() : null;
    }

    public void writeTo(StreamOutput out) throws IOException {
        Version streamOutputVersion = out.getVersion();
        out.writeOptionalString(this.taskId);
        out.writeOptionalString(this.modelId);
        out.writeOptionalString(this.workerNodeId);
        out.writeEnum((Enum)this.requestType);
        if (this.mlTask != null) {
            out.writeBoolean(true);
            this.mlTask.writeTo(out);
        } else {
            out.writeBoolean(false);
        }
        if (this.modelInput != null) {
            out.writeBoolean(true);
            this.modelInput.writeTo(out);
        } else {
            out.writeBoolean(false);
        }
        out.writeOptionalString(this.error);
        out.writeOptionalStringArray(this.workerNodes);
        if (this.registerModelInput != null) {
            out.writeBoolean(true);
            this.registerModelInput.writeTo(out);
        } else {
            out.writeBoolean(false);
        }
        if (streamOutputVersion.onOrAfter(CommonValue.VERSION_2_19_0)) {
            out.writeOptionalString(this.tenantId);
        }
    }

    @Generated
    public static MLForwardInputBuilder builder() {
        return new MLForwardInputBuilder();
    }

    @Generated
    public MLForwardInputBuilder toBuilder() {
        return new MLForwardInputBuilder().taskId(this.taskId).modelId(this.modelId).tenantId(this.tenantId).workerNodeId(this.workerNodeId).requestType(this.requestType).mlTask(this.mlTask).modelInput(this.modelInput).error(this.error).workerNodes(this.workerNodes).registerModelInput(this.registerModelInput);
    }

    @Generated
    public String getTaskId() {
        return this.taskId;
    }

    @Generated
    public String getModelId() {
        return this.modelId;
    }

    @Generated
    public String getTenantId() {
        return this.tenantId;
    }

    @Generated
    public String getWorkerNodeId() {
        return this.workerNodeId;
    }

    @Generated
    public MLForwardRequestType getRequestType() {
        return this.requestType;
    }

    @Generated
    public MLTask getMlTask() {
        return this.mlTask;
    }

    @Generated
    public MLInput getModelInput() {
        return this.modelInput;
    }

    @Generated
    public String getError() {
        return this.error;
    }

    @Generated
    public String[] getWorkerNodes() {
        return this.workerNodes;
    }

    @Generated
    public MLRegisterModelInput getRegisterModelInput() {
        return this.registerModelInput;
    }

    @Generated
    public void setTaskId(String taskId) {
        this.taskId = taskId;
    }

    @Generated
    public void setModelId(String modelId) {
        this.modelId = modelId;
    }

    @Generated
    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    @Generated
    public void setWorkerNodeId(String workerNodeId) {
        this.workerNodeId = workerNodeId;
    }

    @Generated
    public void setRequestType(MLForwardRequestType requestType) {
        this.requestType = requestType;
    }

    @Generated
    public void setMlTask(MLTask mlTask) {
        this.mlTask = mlTask;
    }

    @Generated
    public void setModelInput(MLInput modelInput) {
        this.modelInput = modelInput;
    }

    @Generated
    public void setError(String error) {
        this.error = error;
    }

    @Generated
    public void setWorkerNodes(String[] workerNodes) {
        this.workerNodes = workerNodes;
    }

    @Generated
    public void setRegisterModelInput(MLRegisterModelInput registerModelInput) {
        this.registerModelInput = registerModelInput;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MLForwardInput)) {
            return false;
        }
        MLForwardInput other = (MLForwardInput)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$taskId = this.getTaskId();
        String other$taskId = other.getTaskId();
        if (this$taskId == null ? other$taskId != null : !this$taskId.equals(other$taskId)) {
            return false;
        }
        String this$modelId = this.getModelId();
        String other$modelId = other.getModelId();
        if (this$modelId == null ? other$modelId != null : !this$modelId.equals(other$modelId)) {
            return false;
        }
        String this$tenantId = this.getTenantId();
        String other$tenantId = other.getTenantId();
        if (this$tenantId == null ? other$tenantId != null : !this$tenantId.equals(other$tenantId)) {
            return false;
        }
        String this$workerNodeId = this.getWorkerNodeId();
        String other$workerNodeId = other.getWorkerNodeId();
        if (this$workerNodeId == null ? other$workerNodeId != null : !this$workerNodeId.equals(other$workerNodeId)) {
            return false;
        }
        MLForwardRequestType this$requestType = this.getRequestType();
        MLForwardRequestType other$requestType = other.getRequestType();
        if (this$requestType == null ? other$requestType != null : !((Object)((Object)this$requestType)).equals((Object)other$requestType)) {
            return false;
        }
        MLTask this$mlTask = this.getMlTask();
        MLTask other$mlTask = other.getMlTask();
        if (this$mlTask == null ? other$mlTask != null : !((Object)this$mlTask).equals(other$mlTask)) {
            return false;
        }
        MLInput this$modelInput = this.getModelInput();
        MLInput other$modelInput = other.getModelInput();
        if (this$modelInput == null ? other$modelInput != null : !((Object)this$modelInput).equals(other$modelInput)) {
            return false;
        }
        String this$error = this.getError();
        String other$error = other.getError();
        if (this$error == null ? other$error != null : !this$error.equals(other$error)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getWorkerNodes(), other.getWorkerNodes())) {
            return false;
        }
        MLRegisterModelInput this$registerModelInput = this.getRegisterModelInput();
        MLRegisterModelInput other$registerModelInput = other.getRegisterModelInput();
        return !(this$registerModelInput == null ? other$registerModelInput != null : !((Object)this$registerModelInput).equals(other$registerModelInput));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof MLForwardInput;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $taskId = this.getTaskId();
        result = result * 59 + ($taskId == null ? 43 : $taskId.hashCode());
        String $modelId = this.getModelId();
        result = result * 59 + ($modelId == null ? 43 : $modelId.hashCode());
        String $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : $tenantId.hashCode());
        String $workerNodeId = this.getWorkerNodeId();
        result = result * 59 + ($workerNodeId == null ? 43 : $workerNodeId.hashCode());
        MLForwardRequestType $requestType = this.getRequestType();
        result = result * 59 + ($requestType == null ? 43 : ((Object)((Object)$requestType)).hashCode());
        MLTask $mlTask = this.getMlTask();
        result = result * 59 + ($mlTask == null ? 43 : ((Object)$mlTask).hashCode());
        MLInput $modelInput = this.getModelInput();
        result = result * 59 + ($modelInput == null ? 43 : ((Object)$modelInput).hashCode());
        String $error = this.getError();
        result = result * 59 + ($error == null ? 43 : $error.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getWorkerNodes());
        MLRegisterModelInput $registerModelInput = this.getRegisterModelInput();
        result = result * 59 + ($registerModelInput == null ? 43 : ((Object)$registerModelInput).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "MLForwardInput(taskId=" + this.getTaskId() + ", modelId=" + this.getModelId() + ", tenantId=" + this.getTenantId() + ", workerNodeId=" + this.getWorkerNodeId() + ", requestType=" + String.valueOf((Object)this.getRequestType()) + ", mlTask=" + String.valueOf(this.getMlTask()) + ", modelInput=" + String.valueOf(this.getModelInput()) + ", error=" + this.getError() + ", workerNodes=" + Arrays.deepToString(this.getWorkerNodes()) + ", registerModelInput=" + String.valueOf(this.getRegisterModelInput()) + ")";
    }

    @Generated
    public static class MLForwardInputBuilder {
        @Generated
        private String taskId;
        @Generated
        private String modelId;
        @Generated
        private String tenantId;
        @Generated
        private String workerNodeId;
        @Generated
        private MLForwardRequestType requestType;
        @Generated
        private MLTask mlTask;
        @Generated
        private MLInput modelInput;
        @Generated
        private String error;
        @Generated
        private String[] workerNodes;
        @Generated
        private MLRegisterModelInput registerModelInput;

        @Generated
        MLForwardInputBuilder() {
        }

        @Generated
        public MLForwardInputBuilder taskId(String taskId) {
            this.taskId = taskId;
            return this;
        }

        @Generated
        public MLForwardInputBuilder modelId(String modelId) {
            this.modelId = modelId;
            return this;
        }

        @Generated
        public MLForwardInputBuilder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        @Generated
        public MLForwardInputBuilder workerNodeId(String workerNodeId) {
            this.workerNodeId = workerNodeId;
            return this;
        }

        @Generated
        public MLForwardInputBuilder requestType(MLForwardRequestType requestType) {
            this.requestType = requestType;
            return this;
        }

        @Generated
        public MLForwardInputBuilder mlTask(MLTask mlTask) {
            this.mlTask = mlTask;
            return this;
        }

        @Generated
        public MLForwardInputBuilder modelInput(MLInput modelInput) {
            this.modelInput = modelInput;
            return this;
        }

        @Generated
        public MLForwardInputBuilder error(String error) {
            this.error = error;
            return this;
        }

        @Generated
        public MLForwardInputBuilder workerNodes(String[] workerNodes) {
            this.workerNodes = workerNodes;
            return this;
        }

        @Generated
        public MLForwardInputBuilder registerModelInput(MLRegisterModelInput registerModelInput) {
            this.registerModelInput = registerModelInput;
            return this;
        }

        @Generated
        public MLForwardInput build() {
            return new MLForwardInput(this.taskId, this.modelId, this.tenantId, this.workerNodeId, this.requestType, this.mlTask, this.modelInput, this.error, this.workerNodes, this.registerModelInput);
        }

        @Generated
        public String toString() {
            return "MLForwardInput.MLForwardInputBuilder(taskId=" + this.taskId + ", modelId=" + this.modelId + ", tenantId=" + this.tenantId + ", workerNodeId=" + this.workerNodeId + ", requestType=" + String.valueOf((Object)this.requestType) + ", mlTask=" + String.valueOf(this.mlTask) + ", modelInput=" + String.valueOf(this.modelInput) + ", error=" + this.error + ", workerNodes=" + Arrays.deepToString(this.workerNodes) + ", registerModelInput=" + String.valueOf(this.registerModelInput) + ")";
        }
    }
}

