/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.common.connector.functions.preprocess;

import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.ml.common.dataset.TextDocsInputDataSet;
import org.opensearch.ml.common.dataset.remote.RemoteInferenceInputDataSet;
import org.opensearch.ml.common.input.MLInput;
import org.opensearch.ml.common.utils.StringUtils;
import org.opensearch.script.Script;
import org.opensearch.script.ScriptService;
import org.opensearch.script.ScriptType;
import org.opensearch.script.TemplateScript;

public abstract class ConnectorPreProcessFunction
implements Function<MLInput, RemoteInferenceInputDataSet> {
    @Generated
    private static final Logger log = LogManager.getLogger(ConnectorPreProcessFunction.class);
    protected boolean returnDirectlyForRemoteInferenceInput;

    @Override
    public RemoteInferenceInputDataSet apply(MLInput mlInput) {
        if (mlInput == null) {
            throw new IllegalArgumentException("Preprocess function input can't be null");
        }
        if (this.returnDirectlyForRemoteInferenceInput && mlInput.getInputDataset() instanceof RemoteInferenceInputDataSet) {
            return (RemoteInferenceInputDataSet)mlInput.getInputDataset();
        }
        this.validate(mlInput);
        return this.process(mlInput);
    }

    public abstract void validate(MLInput var1);

    public abstract RemoteInferenceInputDataSet process(MLInput var1);

    public void validateTextDocsInput(MLInput mlInput) {
        if (!(mlInput.getInputDataset() instanceof TextDocsInputDataSet)) {
            log.error(String.format(Locale.ROOT, "This pre_process_function can only support TextDocsInputDataSet, actual input type is: %s", mlInput.getInputDataset().getClass().getName()));
            throw new IllegalArgumentException("This pre_process_function can only support TextDocsInputDataSet which including a list of string with key 'text_docs'");
        }
    }

    protected String executeScript(ScriptService scriptService, String painlessScript, Map<String, Object> params) {
        Script script = new Script(ScriptType.INLINE, "painless", StringUtils.addDefaultMethod(painlessScript), Collections.emptyMap());
        TemplateScript templateScript = ((TemplateScript.Factory)scriptService.compile(script, TemplateScript.CONTEXT)).newInstance(params);
        return templateScript.execute();
    }
}

