/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.common.connector.functions.preprocess;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.opensearch.ml.common.connector.functions.preprocess.ConnectorPreProcessFunction;
import org.opensearch.ml.common.dataset.TextSimilarityInputDataSet;
import org.opensearch.ml.common.dataset.remote.RemoteInferenceInputDataSet;
import org.opensearch.ml.common.input.MLInput;
import org.opensearch.ml.common.utils.StringUtils;

public class BedrockRerankPreProcessFunction
extends ConnectorPreProcessFunction {
    public BedrockRerankPreProcessFunction() {
        this.returnDirectlyForRemoteInferenceInput = true;
    }

    @Override
    public void validate(MLInput mlInput) {
        if (mlInput.getInputDataset() == null) {
            throw new IllegalArgumentException("Input dataset cannot be null.");
        }
        if (!(mlInput.getInputDataset() instanceof TextSimilarityInputDataSet)) {
            throw new IllegalArgumentException("This pre_process_function can only support TextSimilarityInputDataSet");
        }
    }

    @Override
    public RemoteInferenceInputDataSet process(MLInput mlInput) {
        TextSimilarityInputDataSet inputData = (TextSimilarityInputDataSet)mlInput.getInputDataset();
        String queryText = inputData.getQueryText();
        List<String> textDocs = inputData.getTextDocs();
        ArrayList<Map<String, String>> queries = new ArrayList<Map<String, String>>();
        queries.add(Map.of("textQuery", Map.of("text", queryText), "type", "TEXT"));
        ArrayList sources = new ArrayList();
        inputData.getTextDocs().forEach(textDoc -> sources.add(Map.of("inlineDocumentSource", Map.of("textDocument", Map.of("text", textDoc), "type", "TEXT"), "type", "INLINE")));
        Map<String, Object> processedResult = Map.of("parameters", Map.of("queries", queries, "sources", sources, "numberOfResults", textDocs.size()));
        return RemoteInferenceInputDataSet.builder().parameters(StringUtils.convertScriptStringToJsonString(processedResult)).build();
    }
}

