/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.jobscheduler.repackage.com.cronutils.model;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.opensearch.jobscheduler.repackage.com.cronutils.mapper.CronMapper;
import org.opensearch.jobscheduler.repackage.com.cronutils.model.Cron;
import org.opensearch.jobscheduler.repackage.com.cronutils.model.definition.CronConstraint;
import org.opensearch.jobscheduler.repackage.com.cronutils.model.definition.CronDefinition;
import org.opensearch.jobscheduler.repackage.com.cronutils.model.field.CronField;
import org.opensearch.jobscheduler.repackage.com.cronutils.model.field.CronFieldName;
import org.opensearch.jobscheduler.repackage.com.cronutils.model.field.expression.visitor.ValidationFieldExpressionVisitor;
import org.opensearch.jobscheduler.repackage.com.cronutils.utils.Preconditions;

public class RebootCron
implements Cron {
    private static final long serialVersionUID = 7487370826825439099L;
    private final CronDefinition cronDefinition;

    public RebootCron(CronDefinition cronDefinition) {
        this.cronDefinition = Preconditions.checkNotNull(cronDefinition, "CronDefinition must not be null");
    }

    @Override
    public CronField retrieve(CronFieldName name) {
        Preconditions.checkNotNull(name, "CronFieldName must not be null");
        return null;
    }

    @Override
    public Map<CronFieldName, CronField> retrieveFieldsAsMap() {
        return Collections.unmodifiableMap(new HashMap());
    }

    @Override
    public String asString() {
        return "@reboot";
    }

    @Override
    public CronDefinition getCronDefinition() {
        return this.cronDefinition;
    }

    @Override
    public Cron validate() {
        for (Map.Entry<CronFieldName, CronField> field : this.retrieveFieldsAsMap().entrySet()) {
            CronFieldName fieldName = field.getKey();
            field.getValue().getExpression().accept(new ValidationFieldExpressionVisitor(this.getCronDefinition().getFieldDefinition(fieldName).getConstraints()));
        }
        for (CronConstraint constraint : this.getCronDefinition().getCronConstraints()) {
            if (constraint.validate(this)) continue;
            throw new IllegalArgumentException(String.format("Invalid cron expression: %s. %s", this.asString(), constraint.getDescription()));
        }
        return this;
    }

    @Override
    public boolean equivalent(CronMapper cronMapper, Cron cron) {
        return this.asString().equals(cronMapper.map(cron).asString());
    }

    @Override
    public boolean equivalent(Cron cron) {
        return this.asString().equals(cron.asString());
    }
}

