/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.detect.zip;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.compress.archivers.ArchiveException;
import org.apache.commons.compress.archivers.zip.UnsupportedZipFeatureException;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.apache.commons.compress.compressors.CompressorException;
import org.apache.commons.compress.compressors.CompressorStreamFactory;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.CloseShieldInputStream;
import org.apache.commons.io.input.UnsynchronizedByteArrayInputStream;
import org.apache.tika.config.Field;
import org.apache.tika.config.LoadErrorHandler;
import org.apache.tika.config.ServiceLoader;
import org.apache.tika.detect.Detector;
import org.apache.tika.detect.zip.CompressorConstants;
import org.apache.tika.detect.zip.PackageConstants;
import org.apache.tika.detect.zip.StreamingDetectContext;
import org.apache.tika.detect.zip.TikaArchiveStreamFactory;
import org.apache.tika.detect.zip.ZipContainerDetector;
import org.apache.tika.io.BoundedInputStream;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultZipContainerDetector
implements Detector {
    static final MediaType TIFF = MediaType.image((String)"tiff");
    static final byte[][] TIFF_SIGNATURES = new byte[3][];
    private static final long serialVersionUID = 2891763938430295453L;
    private static final Logger LOG = LoggerFactory.getLogger(DefaultZipContainerDetector.class);
    @Field
    int markLimit = 0x1000000;
    private transient ServiceLoader loader;
    private List<ZipContainerDetector> staticZipDetectors;

    public DefaultZipContainerDetector() {
        this(new ServiceLoader(DefaultZipContainerDetector.class.getClassLoader(), LoadErrorHandler.WARN, false));
    }

    public DefaultZipContainerDetector(ServiceLoader loader) {
        this.loader = loader;
        this.staticZipDetectors = loader.loadStaticServiceProviders(ZipContainerDetector.class);
    }

    public DefaultZipContainerDetector(List<ZipContainerDetector> zipDetectors) {
        this.staticZipDetectors = zipDetectors;
    }

    static boolean isZipArchive(MediaType type) {
        return type.equals((Object)PackageConstants.ZIP) || type.equals((Object)PackageConstants.JAR);
    }

    private static boolean isTiff(byte[] prefix) {
        for (byte[] sig : TIFF_SIGNATURES) {
            if (!DefaultZipContainerDetector.arrayStartWith(sig, prefix)) continue;
            return true;
        }
        return false;
    }

    private static boolean arrayStartWith(byte[] needle, byte[] haystack) {
        if (haystack.length < needle.length) {
            return false;
        }
        for (int i = 0; i < needle.length; ++i) {
            if (haystack[i] == needle[i]) continue;
            return false;
        }
        return true;
    }

    static MediaType detectArchiveFormat(byte[] prefix, int length) {
        if (DefaultZipContainerDetector.isTiff(prefix)) {
            return TIFF;
        }
        try {
            String name = TikaArchiveStreamFactory.detect((InputStream)new UnsynchronizedByteArrayInputStream(prefix, 0, length));
            return PackageConstants.getMediaType(name);
        }
        catch (ArchiveException e) {
            return MediaType.OCTET_STREAM;
        }
    }

    static MediaType detectCompressorFormat(byte[] prefix, int length) {
        try {
            String type = CompressorStreamFactory.detect((InputStream)new UnsynchronizedByteArrayInputStream(prefix, 0, length));
            return CompressorConstants.getMediaType(type);
        }
        catch (CompressorException e) {
            return MediaType.OCTET_STREAM;
        }
    }

    @Field
    public void setMarkLimit(int markLimit) {
        this.markLimit = markLimit;
    }

    public int getMarkLimit() {
        return this.markLimit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MediaType detect(InputStream input, Metadata metadata) throws IOException {
        if (input == null) {
            return MediaType.OCTET_STREAM;
        }
        byte[] prefix = new byte[1024];
        input.mark(1024);
        int length = -1;
        try {
            length = IOUtils.read((InputStream)input, (byte[])prefix, (int)0, (int)1024);
        }
        finally {
            input.reset();
        }
        MediaType type = DefaultZipContainerDetector.detectArchiveFormat(prefix, length);
        if (type == TIFF) {
            return TIFF;
        }
        if (DefaultZipContainerDetector.isZipArchive(type)) {
            if (TikaInputStream.isTikaInputStream((InputStream)input)) {
                TikaInputStream tis = TikaInputStream.cast((InputStream)input);
                if (this.markLimit < 0) {
                    tis.getFile();
                }
                if (tis.hasFile()) {
                    return this.detectZipFormatOnFile(tis, metadata);
                }
            }
            return this.detectStreaming(input, metadata);
        }
        if (!type.equals((Object)MediaType.OCTET_STREAM)) {
            return type;
        }
        return DefaultZipContainerDetector.detectCompressorFormat(prefix, length);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private MediaType detectZipFormatOnFile(TikaInputStream tis, Metadata metadata) {
        ZipFile zip = null;
        try {
            zip = new ZipFile(tis.getFile());
            for (ZipContainerDetector zipDetector : this.getDetectors()) {
                MediaType type = zipDetector.detect(zip, tis);
                if (type != null) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("{} detected {}", zipDetector.getClass(), (Object)type.toString());
                    }
                    if (tis.getOpenContainer() == null) {
                        tis.setOpenContainer((Object)zip);
                        return type;
                    }
                    tis.addCloseableResource((Closeable)zip);
                    return type;
                }
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("{} detected null", zipDetector.getClass());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (zip != null) {
            IOUtils.closeQuietly((Closeable)zip);
            return MediaType.APPLICATION_ZIP;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("zip file failed to open; attempting streaming detect");
        }
        if (zip != null) return MediaType.APPLICATION_ZIP;
        try (BufferedInputStream is = new BufferedInputStream(Files.newInputStream(tis.getPath(), new OpenOption[0]));){
            MediaType mediaType = this.detectStreaming(is, metadata);
            return mediaType;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return MediaType.APPLICATION_ZIP;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    MediaType detectStreaming(InputStream input, Metadata metadata) throws IOException {
        BoundedInputStream boundedInputStream = new BoundedInputStream((long)this.markLimit, input);
        boundedInputStream.mark(this.markLimit);
        try {
            MediaType mediaType = this.detectStreaming((InputStream)boundedInputStream, metadata, false);
            return mediaType;
        }
        finally {
            boundedInputStream.reset();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    MediaType detectStreaming(InputStream input, Metadata metadata, boolean allowStoredEntries) throws IOException {
        StreamingDetectContext detectContext = new StreamingDetectContext();
        try (ZipArchiveInputStream zis = new ZipArchiveInputStream((InputStream)new CloseShieldInputStream(input), "UTF8", false, allowStoredEntries);){
            ZipArchiveEntry zae = zis.getNextZipEntry();
            while (zae != null) {
                MediaType mt = this.detect(zae, zis, detectContext);
                if (mt != null) {
                    MediaType mediaType = mt;
                    return mediaType;
                }
                zae = zis.getNextZipEntry();
            }
            return this.finalDetect(detectContext);
        }
        catch (UnsupportedZipFeatureException zfe) {
            if (allowStoredEntries) return this.finalDetect(detectContext);
            if (zfe.getFeature() != UnsupportedZipFeatureException.Feature.DATA_DESCRIPTOR) return this.finalDetect(detectContext);
            input.reset();
            return this.detectStreaming(input, metadata, true);
        }
        catch (SecurityException e) {
            throw e;
        }
        catch (EOFException eOFException) {
            return this.finalDetect(detectContext);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this.finalDetect(detectContext);
    }

    private MediaType detect(ZipArchiveEntry zae, ZipArchiveInputStream zis, StreamingDetectContext detectContext) throws IOException {
        for (ZipContainerDetector d : this.getDetectors()) {
            MediaType mt = d.streamingDetectUpdate(zae, (InputStream)zis, detectContext);
            if (mt == null) continue;
            return mt;
        }
        return null;
    }

    private MediaType finalDetect(StreamingDetectContext detectContext) {
        for (ZipContainerDetector d : this.getDetectors()) {
            MediaType mt = d.streamingDetectFinal(detectContext);
            if (mt == null) continue;
            return mt;
        }
        return MediaType.APPLICATION_ZIP;
    }

    private List<ZipContainerDetector> getDetectors() {
        if (this.loader != null && this.loader.isDynamic()) {
            List dynamicDetectors = this.loader.loadDynamicServiceProviders(ZipContainerDetector.class);
            if (dynamicDetectors.size() > 0) {
                ArrayList<ZipContainerDetector> zipDetectors = new ArrayList<ZipContainerDetector>(this.staticZipDetectors);
                zipDetectors.addAll(dynamicDetectors);
                return zipDetectors;
            }
            return this.staticZipDetectors;
        }
        return this.staticZipDetectors;
    }

    static {
        DefaultZipContainerDetector.TIFF_SIGNATURES[0] = new byte[]{77, 77, 0, 42};
        DefaultZipContainerDetector.TIFF_SIGNATURES[1] = new byte[]{73, 73, 42, 0};
        DefaultZipContainerDetector.TIFF_SIGNATURES[2] = new byte[]{77, 77, 0, 43};
    }
}

