/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.basic;

import java.io.IOException;
import java.util.List;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.basic.BasicObject;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.util.BitReader;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.util.BitWriter;

public class Compact64bitInt
extends BasicObject {
    public static final int CompactUintNullType = 0;
    public static final int CompactUint7bitType = 1;
    public static final int CompactUint14bitType = 2;
    public static final int CompactUint21bitType = 4;
    public static final int CompactUint28bitType = 8;
    public static final int CompactUint35bitType = 16;
    public static final int CompactUint42bitType = 32;
    public static final int CompactUint49bitType = 64;
    public static final int CompactUint64bitType = 128;
    private int type;
    private long decodedValue;

    public Compact64bitInt(long decodedValue) {
        this.decodedValue = decodedValue;
    }

    public Compact64bitInt() {
        this.decodedValue = 0L;
    }

    @Override
    public List<Byte> serializeToByteList() throws IOException {
        BitWriter bitWriter = new BitWriter(9);
        if (this.decodedValue == 0L) {
            bitWriter.appendUInt64(0L, 8);
        } else if (this.decodedValue >= 1L && this.decodedValue <= 127L) {
            bitWriter.appendUInt64(1L, 1);
            bitWriter.appendUInt64(this.decodedValue, 7);
        } else if (this.decodedValue >= 128L && this.decodedValue <= 16383L) {
            bitWriter.appendUInt64(2L, 2);
            bitWriter.appendUInt64(this.decodedValue, 14);
        } else if (this.decodedValue >= 16384L && this.decodedValue <= 0x1FFFFFL) {
            bitWriter.appendUInt64(4L, 3);
            bitWriter.appendUInt64(this.decodedValue, 21);
        } else if (this.decodedValue >= 0x200000L && this.decodedValue <= 0xFFFFFFFL) {
            bitWriter.appendUInt64(8L, 4);
            bitWriter.appendUInt64(this.decodedValue, 28);
        } else if (this.decodedValue >= 0x10000000L && this.decodedValue <= 0x7FFFFFFFFL) {
            bitWriter.appendUInt64(16L, 5);
            bitWriter.appendUInt64(this.decodedValue, 35);
        } else if (this.decodedValue >= 0x800000000L && this.decodedValue <= 0x3FFFFFFFFFFL) {
            bitWriter.appendUInt64(32L, 6);
            bitWriter.appendUInt64(this.decodedValue, 42);
        } else if (this.decodedValue >= 0x40000000000L && this.decodedValue <= 0x1FFFFFFFFFFFFL) {
            bitWriter.appendUInt64(64L, 7);
            bitWriter.appendUInt64(this.decodedValue, 49);
        } else if (this.decodedValue >= 0x2000000000000L) {
            bitWriter.appendUInt64(128L, 8);
            bitWriter.appendUInt64(this.decodedValue, 64);
        }
        return bitWriter.getByteList();
    }

    @Override
    protected int doDeserializeFromByteArray(byte[] byteArray, int startIndex) throws IOException {
        int numberOfContinousZeroBit;
        BitReader bitReader = new BitReader(byteArray, startIndex);
        for (numberOfContinousZeroBit = 0; numberOfContinousZeroBit < 8 && bitReader.moveNext() && !bitReader.getCurrent(); ++numberOfContinousZeroBit) {
        }
        switch (numberOfContinousZeroBit) {
            case 0: {
                this.decodedValue = bitReader.readUInt64(7);
                this.type = 1;
                return 1;
            }
            case 1: {
                this.decodedValue = bitReader.readUInt64(14);
                this.type = 2;
                return 2;
            }
            case 2: {
                this.decodedValue = bitReader.readUInt64(21);
                this.type = 4;
                return 3;
            }
            case 3: {
                this.decodedValue = bitReader.readUInt64(28);
                this.type = 8;
                return 4;
            }
            case 4: {
                this.decodedValue = bitReader.readUInt64(35);
                this.type = 16;
                return 5;
            }
            case 5: {
                this.decodedValue = bitReader.readUInt64(42);
                this.type = 32;
                return 6;
            }
            case 6: {
                this.decodedValue = bitReader.readUInt64(49);
                this.type = 64;
                return 7;
            }
            case 7: {
                this.decodedValue = bitReader.readUInt64(64);
                this.type = 128;
                return 9;
            }
            case 8: {
                this.decodedValue = 0L;
                this.type = 0;
                return 1;
            }
        }
        throw new IllegalArgumentException("Failed to parse the Compact64bitInt, the type value is unexpected");
    }

    public int getType() {
        return this.type;
    }

    public Compact64bitInt setType(int type) {
        this.type = type;
        return this;
    }

    public long getDecodedValue() {
        return this.decodedValue;
    }

    public Compact64bitInt setDecodedValue(long decodedValue) {
        this.decodedValue = decodedValue;
        return this;
    }
}

