/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.crt.auth.credentials;

public class Credentials {
    private byte[] accessKeyId;
    private byte[] secretAccessKey;
    private byte[] sessionToken;
    private long expirationTimePointSecs;

    public Credentials() {
    }

    public Credentials(byte[] accessKeyId, byte[] secretAccessKey, byte[] sessionToken) {
        this(accessKeyId, secretAccessKey, sessionToken, Long.MAX_VALUE);
    }

    public Credentials(byte[] accessKeyId, byte[] secretAccessKey, byte[] sessionToken, long expirationTimePointSecs) {
        if (accessKeyId == null || secretAccessKey == null) {
            throw new IllegalArgumentException("Credentials - accessKeyId and secretAccessKey must be non null");
        }
        this.accessKeyId = accessKeyId;
        this.secretAccessKey = secretAccessKey;
        this.sessionToken = sessionToken;
        this.expirationTimePointSecs = expirationTimePointSecs;
    }

    public static Credentials createAnonymousCredentials() {
        return new Credentials();
    }

    public byte[] getAccessKeyId() {
        return this.accessKeyId;
    }

    public byte[] getSecretAccessKey() {
        return this.secretAccessKey;
    }

    public byte[] getSessionToken() {
        return this.sessionToken;
    }

    public long getExpirationTimePointSecs() {
        return this.expirationTimePointSecs;
    }
}

