/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2Client;
import software.amazon.awssdk.services.ec2.internal.UserAgentUtils;
import software.amazon.awssdk.services.ec2.model.GetInstanceTypesFromInstanceRequirementsRequest;
import software.amazon.awssdk.services.ec2.model.GetInstanceTypesFromInstanceRequirementsResponse;
import software.amazon.awssdk.services.ec2.model.InstanceTypeInfoFromInstanceRequirements;

public class GetInstanceTypesFromInstanceRequirementsIterable
implements SdkIterable<GetInstanceTypesFromInstanceRequirementsResponse> {
    private final Ec2Client client;
    private final GetInstanceTypesFromInstanceRequirementsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetInstanceTypesFromInstanceRequirementsIterable(Ec2Client client, GetInstanceTypesFromInstanceRequirementsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new GetInstanceTypesFromInstanceRequirementsResponseFetcher();
    }

    public Iterator<GetInstanceTypesFromInstanceRequirementsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<InstanceTypeInfoFromInstanceRequirements> instanceTypes() {
        Function<GetInstanceTypesFromInstanceRequirementsResponse, Iterator> getIterator = response -> {
            if (response != null && response.instanceTypes() != null) {
                return response.instanceTypes().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class GetInstanceTypesFromInstanceRequirementsResponseFetcher
    implements SyncPageFetcher<GetInstanceTypesFromInstanceRequirementsResponse> {
        private GetInstanceTypesFromInstanceRequirementsResponseFetcher() {
        }

        public boolean hasNextPage(GetInstanceTypesFromInstanceRequirementsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public GetInstanceTypesFromInstanceRequirementsResponse nextPage(GetInstanceTypesFromInstanceRequirementsResponse previousPage) {
            if (previousPage == null) {
                return GetInstanceTypesFromInstanceRequirementsIterable.this.client.getInstanceTypesFromInstanceRequirements(GetInstanceTypesFromInstanceRequirementsIterable.this.firstRequest);
            }
            return GetInstanceTypesFromInstanceRequirementsIterable.this.client.getInstanceTypesFromInstanceRequirements((GetInstanceTypesFromInstanceRequirementsRequest)((Object)GetInstanceTypesFromInstanceRequirementsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

