/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2AsyncClient;
import software.amazon.awssdk.services.ec2.internal.UserAgentUtils;
import software.amazon.awssdk.services.ec2.model.DescribeTrafficMirrorFiltersRequest;
import software.amazon.awssdk.services.ec2.model.DescribeTrafficMirrorFiltersResponse;
import software.amazon.awssdk.services.ec2.model.TrafficMirrorFilter;

public class DescribeTrafficMirrorFiltersPublisher
implements SdkPublisher<DescribeTrafficMirrorFiltersResponse> {
    private final Ec2AsyncClient client;
    private final DescribeTrafficMirrorFiltersRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeTrafficMirrorFiltersPublisher(Ec2AsyncClient client, DescribeTrafficMirrorFiltersRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeTrafficMirrorFiltersPublisher(Ec2AsyncClient client, DescribeTrafficMirrorFiltersRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeTrafficMirrorFiltersResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeTrafficMirrorFiltersResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<TrafficMirrorFilter> trafficMirrorFilters() {
        Function<DescribeTrafficMirrorFiltersResponse, Iterator> getIterator = response -> {
            if (response != null && response.trafficMirrorFilters() != null) {
                return response.trafficMirrorFilters().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeTrafficMirrorFiltersResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeTrafficMirrorFiltersResponseFetcher
    implements AsyncPageFetcher<DescribeTrafficMirrorFiltersResponse> {
        private DescribeTrafficMirrorFiltersResponseFetcher() {
        }

        public boolean hasNextPage(DescribeTrafficMirrorFiltersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeTrafficMirrorFiltersResponse> nextPage(DescribeTrafficMirrorFiltersResponse previousPage) {
            if (previousPage == null) {
                return DescribeTrafficMirrorFiltersPublisher.this.client.describeTrafficMirrorFilters(DescribeTrafficMirrorFiltersPublisher.this.firstRequest);
            }
            return DescribeTrafficMirrorFiltersPublisher.this.client.describeTrafficMirrorFilters((DescribeTrafficMirrorFiltersRequest)((Object)DescribeTrafficMirrorFiltersPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

