/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2Client;
import software.amazon.awssdk.services.ec2.internal.UserAgentUtils;
import software.amazon.awssdk.services.ec2.model.DescribePublicIpv4PoolsRequest;
import software.amazon.awssdk.services.ec2.model.DescribePublicIpv4PoolsResponse;
import software.amazon.awssdk.services.ec2.model.PublicIpv4Pool;

public class DescribePublicIpv4PoolsIterable
implements SdkIterable<DescribePublicIpv4PoolsResponse> {
    private final Ec2Client client;
    private final DescribePublicIpv4PoolsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribePublicIpv4PoolsIterable(Ec2Client client, DescribePublicIpv4PoolsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribePublicIpv4PoolsResponseFetcher();
    }

    public Iterator<DescribePublicIpv4PoolsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<PublicIpv4Pool> publicIpv4Pools() {
        Function<DescribePublicIpv4PoolsResponse, Iterator> getIterator = response -> {
            if (response != null && response.publicIpv4Pools() != null) {
                return response.publicIpv4Pools().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribePublicIpv4PoolsResponseFetcher
    implements SyncPageFetcher<DescribePublicIpv4PoolsResponse> {
        private DescribePublicIpv4PoolsResponseFetcher() {
        }

        public boolean hasNextPage(DescribePublicIpv4PoolsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribePublicIpv4PoolsResponse nextPage(DescribePublicIpv4PoolsResponse previousPage) {
            if (previousPage == null) {
                return DescribePublicIpv4PoolsIterable.this.client.describePublicIpv4Pools(DescribePublicIpv4PoolsIterable.this.firstRequest);
            }
            return DescribePublicIpv4PoolsIterable.this.client.describePublicIpv4Pools((DescribePublicIpv4PoolsRequest)((Object)DescribePublicIpv4PoolsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

