/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2Client;
import software.amazon.awssdk.services.ec2.internal.UserAgentUtils;
import software.amazon.awssdk.services.ec2.model.DescribeNetworkInsightsPathsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeNetworkInsightsPathsResponse;
import software.amazon.awssdk.services.ec2.model.NetworkInsightsPath;

public class DescribeNetworkInsightsPathsIterable
implements SdkIterable<DescribeNetworkInsightsPathsResponse> {
    private final Ec2Client client;
    private final DescribeNetworkInsightsPathsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeNetworkInsightsPathsIterable(Ec2Client client, DescribeNetworkInsightsPathsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeNetworkInsightsPathsResponseFetcher();
    }

    public Iterator<DescribeNetworkInsightsPathsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<NetworkInsightsPath> networkInsightsPaths() {
        Function<DescribeNetworkInsightsPathsResponse, Iterator> getIterator = response -> {
            if (response != null && response.networkInsightsPaths() != null) {
                return response.networkInsightsPaths().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeNetworkInsightsPathsResponseFetcher
    implements SyncPageFetcher<DescribeNetworkInsightsPathsResponse> {
        private DescribeNetworkInsightsPathsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeNetworkInsightsPathsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeNetworkInsightsPathsResponse nextPage(DescribeNetworkInsightsPathsResponse previousPage) {
            if (previousPage == null) {
                return DescribeNetworkInsightsPathsIterable.this.client.describeNetworkInsightsPaths(DescribeNetworkInsightsPathsIterable.this.firstRequest);
            }
            return DescribeNetworkInsightsPathsIterable.this.client.describeNetworkInsightsPaths((DescribeNetworkInsightsPathsRequest)((Object)DescribeNetworkInsightsPathsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

