/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum TpmSupportValues {
    V2_0("v2.0"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, TpmSupportValues> VALUE_MAP;
    private final String value;

    private TpmSupportValues(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static TpmSupportValues fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<TpmSupportValues> knownValues() {
        EnumSet<TpmSupportValues> knownValues = EnumSet.allOf(TpmSupportValues.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(TpmSupportValues.class, TpmSupportValues::toString);
    }
}

