/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.services.ec2.model.PurchaseRequest;
import software.amazon.awssdk.services.ec2.model.PurchaseRequestSetCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PurchaseScheduledInstancesRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, PurchaseScheduledInstancesRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientToken").getter(PurchaseScheduledInstancesRequest.getter(PurchaseScheduledInstancesRequest::clientToken)).setter(PurchaseScheduledInstancesRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").unmarshallLocationName("ClientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DryRun").getter(PurchaseScheduledInstancesRequest.getter(PurchaseScheduledInstancesRequest::dryRun)).setter(PurchaseScheduledInstancesRequest.setter(Builder::dryRun)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun").unmarshallLocationName("DryRun").build()}).build();
    private static final SdkField<List<PurchaseRequest>> PURCHASE_REQUESTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PurchaseRequests").getter(PurchaseScheduledInstancesRequest.getter(PurchaseScheduledInstancesRequest::purchaseRequests)).setter(PurchaseScheduledInstancesRequest.setter(Builder::purchaseRequests)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PurchaseRequest").unmarshallLocationName("PurchaseRequest").build(), ListTrait.builder().memberLocationName("PurchaseRequest").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PurchaseRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PurchaseRequest").unmarshallLocationName("PurchaseRequest").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD, DRY_RUN_FIELD, PURCHASE_REQUESTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PurchaseScheduledInstancesRequest.memberNameToFieldInitializer();
    private final String clientToken;
    private final Boolean dryRun;
    private final List<PurchaseRequest> purchaseRequests;

    private PurchaseScheduledInstancesRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.dryRun = builder.dryRun;
        this.purchaseRequests = builder.purchaseRequests;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final Boolean dryRun() {
        return this.dryRun;
    }

    public final boolean hasPurchaseRequests() {
        return this.purchaseRequests != null && !(this.purchaseRequests instanceof SdkAutoConstructList);
    }

    public final List<PurchaseRequest> purchaseRequests() {
        return this.purchaseRequests;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.dryRun());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPurchaseRequests() ? this.purchaseRequests() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PurchaseScheduledInstancesRequest)) {
            return false;
        }
        PurchaseScheduledInstancesRequest other = (PurchaseScheduledInstancesRequest)((Object)obj);
        return Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.dryRun(), other.dryRun()) && this.hasPurchaseRequests() == other.hasPurchaseRequests() && Objects.equals(this.purchaseRequests(), other.purchaseRequests());
    }

    public final String toString() {
        return ToString.builder((String)"PurchaseScheduledInstancesRequest").add("ClientToken", (Object)this.clientToken()).add("DryRun", (Object)this.dryRun()).add("PurchaseRequests", this.hasPurchaseRequests() ? this.purchaseRequests() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "DryRun": {
                return Optional.ofNullable(clazz.cast(this.dryRun()));
            }
            case "PurchaseRequests": {
                return Optional.ofNullable(clazz.cast(this.purchaseRequests()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ClientToken", CLIENT_TOKEN_FIELD);
        map.put("DryRun", DRY_RUN_FIELD);
        map.put("PurchaseRequest", PURCHASE_REQUESTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PurchaseScheduledInstancesRequest, T> g) {
        return obj -> g.apply((PurchaseScheduledInstancesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private String clientToken;
        private Boolean dryRun;
        private List<PurchaseRequest> purchaseRequests = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PurchaseScheduledInstancesRequest model) {
            super(model);
            this.clientToken(model.clientToken);
            this.dryRun(model.dryRun);
            this.purchaseRequests(model.purchaseRequests);
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final Boolean getDryRun() {
            return this.dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public final List<PurchaseRequest.Builder> getPurchaseRequests() {
            List<PurchaseRequest.Builder> result = PurchaseRequestSetCopier.copyToBuilder(this.purchaseRequests);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPurchaseRequests(Collection<PurchaseRequest.BuilderImpl> purchaseRequests) {
            this.purchaseRequests = PurchaseRequestSetCopier.copyFromBuilder(purchaseRequests);
        }

        @Override
        public final Builder purchaseRequests(Collection<PurchaseRequest> purchaseRequests) {
            this.purchaseRequests = PurchaseRequestSetCopier.copy(purchaseRequests);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder purchaseRequests(PurchaseRequest ... purchaseRequests) {
            this.purchaseRequests(Arrays.asList(purchaseRequests));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder purchaseRequests(Consumer<PurchaseRequest.Builder> ... purchaseRequests) {
            this.purchaseRequests(Stream.of(purchaseRequests).map(c -> (PurchaseRequest)((PurchaseRequest.Builder)PurchaseRequest.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PurchaseScheduledInstancesRequest build() {
            return new PurchaseScheduledInstancesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PurchaseScheduledInstancesRequest> {
        public Builder clientToken(String var1);

        public Builder dryRun(Boolean var1);

        public Builder purchaseRequests(Collection<PurchaseRequest> var1);

        public Builder purchaseRequests(PurchaseRequest ... var1);

        public Builder purchaseRequests(Consumer<PurchaseRequest.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

