/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.DeviceTrustProviderType;
import software.amazon.awssdk.services.ec2.model.DeviceTrustProviderTypeListCopier;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.services.ec2.model.VerifiedAccessInstanceOpenVpnClientConfiguration;
import software.amazon.awssdk.services.ec2.model.VerifiedAccessInstanceOpenVpnClientConfigurationListCopier;
import software.amazon.awssdk.services.ec2.model.VerifiedAccessInstanceUserTrustProviderClientConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ExportVerifiedAccessInstanceClientConfigurationResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, ExportVerifiedAccessInstanceClientConfigurationResponse> {
    private static final SdkField<String> VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Version").getter(ExportVerifiedAccessInstanceClientConfigurationResponse.getter(ExportVerifiedAccessInstanceClientConfigurationResponse::version)).setter(ExportVerifiedAccessInstanceClientConfigurationResponse.setter(Builder::version)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Version").unmarshallLocationName("version").build()}).build();
    private static final SdkField<String> VERIFIED_ACCESS_INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VerifiedAccessInstanceId").getter(ExportVerifiedAccessInstanceClientConfigurationResponse.getter(ExportVerifiedAccessInstanceClientConfigurationResponse::verifiedAccessInstanceId)).setter(ExportVerifiedAccessInstanceClientConfigurationResponse.setter(Builder::verifiedAccessInstanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VerifiedAccessInstanceId").unmarshallLocationName("verifiedAccessInstanceId").build()}).build();
    private static final SdkField<String> REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Region").getter(ExportVerifiedAccessInstanceClientConfigurationResponse.getter(ExportVerifiedAccessInstanceClientConfigurationResponse::region)).setter(ExportVerifiedAccessInstanceClientConfigurationResponse.setter(Builder::region)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Region").unmarshallLocationName("region").build()}).build();
    private static final SdkField<List<String>> DEVICE_TRUST_PROVIDERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DeviceTrustProviders").getter(ExportVerifiedAccessInstanceClientConfigurationResponse.getter(ExportVerifiedAccessInstanceClientConfigurationResponse::deviceTrustProvidersAsStrings)).setter(ExportVerifiedAccessInstanceClientConfigurationResponse.setter(Builder::deviceTrustProvidersWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceTrustProviderSet").unmarshallLocationName("deviceTrustProviderSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<VerifiedAccessInstanceUserTrustProviderClientConfiguration> USER_TRUST_PROVIDER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("UserTrustProvider").getter(ExportVerifiedAccessInstanceClientConfigurationResponse.getter(ExportVerifiedAccessInstanceClientConfigurationResponse::userTrustProvider)).setter(ExportVerifiedAccessInstanceClientConfigurationResponse.setter(Builder::userTrustProvider)).constructor(VerifiedAccessInstanceUserTrustProviderClientConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserTrustProvider").unmarshallLocationName("userTrustProvider").build()}).build();
    private static final SdkField<List<VerifiedAccessInstanceOpenVpnClientConfiguration>> OPEN_VPN_CONFIGURATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("OpenVpnConfigurations").getter(ExportVerifiedAccessInstanceClientConfigurationResponse.getter(ExportVerifiedAccessInstanceClientConfigurationResponse::openVpnConfigurations)).setter(ExportVerifiedAccessInstanceClientConfigurationResponse.setter(Builder::openVpnConfigurations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OpenVpnConfigurationSet").unmarshallLocationName("openVpnConfigurationSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(VerifiedAccessInstanceOpenVpnClientConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VERSION_FIELD, VERIFIED_ACCESS_INSTANCE_ID_FIELD, REGION_FIELD, DEVICE_TRUST_PROVIDERS_FIELD, USER_TRUST_PROVIDER_FIELD, OPEN_VPN_CONFIGURATIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ExportVerifiedAccessInstanceClientConfigurationResponse.memberNameToFieldInitializer();
    private final String version;
    private final String verifiedAccessInstanceId;
    private final String region;
    private final List<String> deviceTrustProviders;
    private final VerifiedAccessInstanceUserTrustProviderClientConfiguration userTrustProvider;
    private final List<VerifiedAccessInstanceOpenVpnClientConfiguration> openVpnConfigurations;

    private ExportVerifiedAccessInstanceClientConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.version = builder.version;
        this.verifiedAccessInstanceId = builder.verifiedAccessInstanceId;
        this.region = builder.region;
        this.deviceTrustProviders = builder.deviceTrustProviders;
        this.userTrustProvider = builder.userTrustProvider;
        this.openVpnConfigurations = builder.openVpnConfigurations;
    }

    public final String version() {
        return this.version;
    }

    public final String verifiedAccessInstanceId() {
        return this.verifiedAccessInstanceId;
    }

    public final String region() {
        return this.region;
    }

    public final List<DeviceTrustProviderType> deviceTrustProviders() {
        return DeviceTrustProviderTypeListCopier.copyStringToEnum(this.deviceTrustProviders);
    }

    public final boolean hasDeviceTrustProviders() {
        return this.deviceTrustProviders != null && !(this.deviceTrustProviders instanceof SdkAutoConstructList);
    }

    public final List<String> deviceTrustProvidersAsStrings() {
        return this.deviceTrustProviders;
    }

    public final VerifiedAccessInstanceUserTrustProviderClientConfiguration userTrustProvider() {
        return this.userTrustProvider;
    }

    public final boolean hasOpenVpnConfigurations() {
        return this.openVpnConfigurations != null && !(this.openVpnConfigurations instanceof SdkAutoConstructList);
    }

    public final List<VerifiedAccessInstanceOpenVpnClientConfiguration> openVpnConfigurations() {
        return this.openVpnConfigurations;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.version());
        hashCode = 31 * hashCode + Objects.hashCode(this.verifiedAccessInstanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.region());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDeviceTrustProviders() ? this.deviceTrustProvidersAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.userTrustProvider());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOpenVpnConfigurations() ? this.openVpnConfigurations() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExportVerifiedAccessInstanceClientConfigurationResponse)) {
            return false;
        }
        ExportVerifiedAccessInstanceClientConfigurationResponse other = (ExportVerifiedAccessInstanceClientConfigurationResponse)((Object)obj);
        return Objects.equals(this.version(), other.version()) && Objects.equals(this.verifiedAccessInstanceId(), other.verifiedAccessInstanceId()) && Objects.equals(this.region(), other.region()) && this.hasDeviceTrustProviders() == other.hasDeviceTrustProviders() && Objects.equals(this.deviceTrustProvidersAsStrings(), other.deviceTrustProvidersAsStrings()) && Objects.equals(this.userTrustProvider(), other.userTrustProvider()) && this.hasOpenVpnConfigurations() == other.hasOpenVpnConfigurations() && Objects.equals(this.openVpnConfigurations(), other.openVpnConfigurations());
    }

    public final String toString() {
        return ToString.builder((String)"ExportVerifiedAccessInstanceClientConfigurationResponse").add("Version", (Object)this.version()).add("VerifiedAccessInstanceId", (Object)this.verifiedAccessInstanceId()).add("Region", (Object)this.region()).add("DeviceTrustProviders", this.hasDeviceTrustProviders() ? this.deviceTrustProvidersAsStrings() : null).add("UserTrustProvider", (Object)this.userTrustProvider()).add("OpenVpnConfigurations", this.hasOpenVpnConfigurations() ? this.openVpnConfigurations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Version": {
                return Optional.ofNullable(clazz.cast(this.version()));
            }
            case "VerifiedAccessInstanceId": {
                return Optional.ofNullable(clazz.cast(this.verifiedAccessInstanceId()));
            }
            case "Region": {
                return Optional.ofNullable(clazz.cast(this.region()));
            }
            case "DeviceTrustProviders": {
                return Optional.ofNullable(clazz.cast(this.deviceTrustProvidersAsStrings()));
            }
            case "UserTrustProvider": {
                return Optional.ofNullable(clazz.cast(this.userTrustProvider()));
            }
            case "OpenVpnConfigurations": {
                return Optional.ofNullable(clazz.cast(this.openVpnConfigurations()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Version", VERSION_FIELD);
        map.put("VerifiedAccessInstanceId", VERIFIED_ACCESS_INSTANCE_ID_FIELD);
        map.put("Region", REGION_FIELD);
        map.put("DeviceTrustProviderSet", DEVICE_TRUST_PROVIDERS_FIELD);
        map.put("UserTrustProvider", USER_TRUST_PROVIDER_FIELD);
        map.put("OpenVpnConfigurationSet", OPEN_VPN_CONFIGURATIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ExportVerifiedAccessInstanceClientConfigurationResponse, T> g) {
        return obj -> g.apply((ExportVerifiedAccessInstanceClientConfigurationResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private String version;
        private String verifiedAccessInstanceId;
        private String region;
        private List<String> deviceTrustProviders = DefaultSdkAutoConstructList.getInstance();
        private VerifiedAccessInstanceUserTrustProviderClientConfiguration userTrustProvider;
        private List<VerifiedAccessInstanceOpenVpnClientConfiguration> openVpnConfigurations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ExportVerifiedAccessInstanceClientConfigurationResponse model) {
            super(model);
            this.version(model.version);
            this.verifiedAccessInstanceId(model.verifiedAccessInstanceId);
            this.region(model.region);
            this.deviceTrustProvidersWithStrings(model.deviceTrustProviders);
            this.userTrustProvider(model.userTrustProvider);
            this.openVpnConfigurations(model.openVpnConfigurations);
        }

        public final String getVersion() {
            return this.version;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final String getVerifiedAccessInstanceId() {
            return this.verifiedAccessInstanceId;
        }

        public final void setVerifiedAccessInstanceId(String verifiedAccessInstanceId) {
            this.verifiedAccessInstanceId = verifiedAccessInstanceId;
        }

        @Override
        public final Builder verifiedAccessInstanceId(String verifiedAccessInstanceId) {
            this.verifiedAccessInstanceId = verifiedAccessInstanceId;
            return this;
        }

        public final String getRegion() {
            return this.region;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        @Override
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        public final Collection<String> getDeviceTrustProviders() {
            if (this.deviceTrustProviders instanceof SdkAutoConstructList) {
                return null;
            }
            return this.deviceTrustProviders;
        }

        public final void setDeviceTrustProviders(Collection<String> deviceTrustProviders) {
            this.deviceTrustProviders = DeviceTrustProviderTypeListCopier.copy(deviceTrustProviders);
        }

        @Override
        public final Builder deviceTrustProvidersWithStrings(Collection<String> deviceTrustProviders) {
            this.deviceTrustProviders = DeviceTrustProviderTypeListCopier.copy(deviceTrustProviders);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deviceTrustProvidersWithStrings(String ... deviceTrustProviders) {
            this.deviceTrustProvidersWithStrings(Arrays.asList(deviceTrustProviders));
            return this;
        }

        @Override
        public final Builder deviceTrustProviders(Collection<DeviceTrustProviderType> deviceTrustProviders) {
            this.deviceTrustProviders = DeviceTrustProviderTypeListCopier.copyEnumToString(deviceTrustProviders);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deviceTrustProviders(DeviceTrustProviderType ... deviceTrustProviders) {
            this.deviceTrustProviders(Arrays.asList(deviceTrustProviders));
            return this;
        }

        public final VerifiedAccessInstanceUserTrustProviderClientConfiguration.Builder getUserTrustProvider() {
            return this.userTrustProvider != null ? this.userTrustProvider.toBuilder() : null;
        }

        public final void setUserTrustProvider(VerifiedAccessInstanceUserTrustProviderClientConfiguration.BuilderImpl userTrustProvider) {
            this.userTrustProvider = userTrustProvider != null ? userTrustProvider.build() : null;
        }

        @Override
        public final Builder userTrustProvider(VerifiedAccessInstanceUserTrustProviderClientConfiguration userTrustProvider) {
            this.userTrustProvider = userTrustProvider;
            return this;
        }

        public final List<VerifiedAccessInstanceOpenVpnClientConfiguration.Builder> getOpenVpnConfigurations() {
            List<VerifiedAccessInstanceOpenVpnClientConfiguration.Builder> result = VerifiedAccessInstanceOpenVpnClientConfigurationListCopier.copyToBuilder(this.openVpnConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOpenVpnConfigurations(Collection<VerifiedAccessInstanceOpenVpnClientConfiguration.BuilderImpl> openVpnConfigurations) {
            this.openVpnConfigurations = VerifiedAccessInstanceOpenVpnClientConfigurationListCopier.copyFromBuilder(openVpnConfigurations);
        }

        @Override
        public final Builder openVpnConfigurations(Collection<VerifiedAccessInstanceOpenVpnClientConfiguration> openVpnConfigurations) {
            this.openVpnConfigurations = VerifiedAccessInstanceOpenVpnClientConfigurationListCopier.copy(openVpnConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder openVpnConfigurations(VerifiedAccessInstanceOpenVpnClientConfiguration ... openVpnConfigurations) {
            this.openVpnConfigurations(Arrays.asList(openVpnConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder openVpnConfigurations(Consumer<VerifiedAccessInstanceOpenVpnClientConfiguration.Builder> ... openVpnConfigurations) {
            this.openVpnConfigurations(Stream.of(openVpnConfigurations).map(c -> (VerifiedAccessInstanceOpenVpnClientConfiguration)((VerifiedAccessInstanceOpenVpnClientConfiguration.Builder)VerifiedAccessInstanceOpenVpnClientConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ExportVerifiedAccessInstanceClientConfigurationResponse build() {
            return new ExportVerifiedAccessInstanceClientConfigurationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ExportVerifiedAccessInstanceClientConfigurationResponse> {
        public Builder version(String var1);

        public Builder verifiedAccessInstanceId(String var1);

        public Builder region(String var1);

        public Builder deviceTrustProvidersWithStrings(Collection<String> var1);

        public Builder deviceTrustProvidersWithStrings(String ... var1);

        public Builder deviceTrustProviders(Collection<DeviceTrustProviderType> var1);

        public Builder deviceTrustProviders(DeviceTrustProviderType ... var1);

        public Builder userTrustProvider(VerifiedAccessInstanceUserTrustProviderClientConfiguration var1);

        default public Builder userTrustProvider(Consumer<VerifiedAccessInstanceUserTrustProviderClientConfiguration.Builder> userTrustProvider) {
            return this.userTrustProvider((VerifiedAccessInstanceUserTrustProviderClientConfiguration)((VerifiedAccessInstanceUserTrustProviderClientConfiguration.Builder)VerifiedAccessInstanceUserTrustProviderClientConfiguration.builder().applyMutation(userTrustProvider)).build());
        }

        public Builder openVpnConfigurations(Collection<VerifiedAccessInstanceOpenVpnClientConfiguration> var1);

        public Builder openVpnConfigurations(VerifiedAccessInstanceOpenVpnClientConfiguration ... var1);

        public Builder openVpnConfigurations(Consumer<VerifiedAccessInstanceOpenVpnClientConfiguration.Builder> ... var1);
    }
}

