"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SpanExpression = void 0;
var _node = require("../node");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

class SpanExpression extends _node.PPLNode {
  constructor(name, children, fieldExpression, literalValue, timeUnit) {
    super(name, children);
    this.fieldExpression = fieldExpression;
    this.literalValue = literalValue;
    this.timeUnit = timeUnit;
  }
  getTokens() {
    return {
      field: this.fieldExpression,
      literal_value: this.literalValue,
      time_unit: this.timeUnit
    };
  }
  toString() {
    return `span(${this.fieldExpression}, ${this.literalValue}${this.timeUnit})`;
  }
}
exports.SpanExpression = SpanExpression;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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