/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.ja;

import java.io.IOException;
import java.io.StringReader;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.ja.Token;
import org.apache.lucene.analysis.ja.ViterbiNBest;
import org.apache.lucene.analysis.ja.dict.CharacterDefinition;
import org.apache.lucene.analysis.ja.dict.ConnectionCosts;
import org.apache.lucene.analysis.ja.dict.JaMorphData;
import org.apache.lucene.analysis.ja.dict.TokenInfoDictionary;
import org.apache.lucene.analysis.ja.dict.TokenInfoFST;
import org.apache.lucene.analysis.ja.dict.UnknownDictionary;
import org.apache.lucene.analysis.ja.dict.UserDictionary;
import org.apache.lucene.analysis.ja.tokenattributes.BaseFormAttribute;
import org.apache.lucene.analysis.ja.tokenattributes.InflectionAttribute;
import org.apache.lucene.analysis.ja.tokenattributes.PartOfSpeechAttribute;
import org.apache.lucene.analysis.ja.tokenattributes.ReadingAttribute;
import org.apache.lucene.analysis.morph.GraphvizFormatter;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionLengthAttribute;
import org.apache.lucene.util.AttributeFactory;
import org.apache.lucene.util.IgnoreRandomChains;
import org.apache.lucene.util.fst.FST;

public final class JapaneseTokenizer
extends Tokenizer {
    public static final Mode DEFAULT_MODE = Mode.SEARCH;
    private static final boolean VERBOSE = false;
    private int lastTokenPos;
    private final ViterbiNBest viterbi;
    private final CharTermAttribute termAtt = (CharTermAttribute)this.addAttribute(CharTermAttribute.class);
    private final OffsetAttribute offsetAtt = (OffsetAttribute)this.addAttribute(OffsetAttribute.class);
    private final PositionIncrementAttribute posIncAtt = (PositionIncrementAttribute)this.addAttribute(PositionIncrementAttribute.class);
    private final PositionLengthAttribute posLengthAtt = (PositionLengthAttribute)this.addAttribute(PositionLengthAttribute.class);
    private final BaseFormAttribute basicFormAtt = (BaseFormAttribute)this.addAttribute(BaseFormAttribute.class);
    private final PartOfSpeechAttribute posAtt = (PartOfSpeechAttribute)this.addAttribute(PartOfSpeechAttribute.class);
    private final ReadingAttribute readingAtt = (ReadingAttribute)this.addAttribute(ReadingAttribute.class);
    private final InflectionAttribute inflectionAtt = (InflectionAttribute)this.addAttribute(InflectionAttribute.class);

    public JapaneseTokenizer(UserDictionary userDictionary, boolean discardPunctuation, Mode mode) {
        this(DEFAULT_TOKEN_ATTRIBUTE_FACTORY, userDictionary, discardPunctuation, true, mode);
    }

    public JapaneseTokenizer(UserDictionary userDictionary, boolean discardPunctuation, boolean discardCompoundToken, Mode mode) {
        this(DEFAULT_TOKEN_ATTRIBUTE_FACTORY, userDictionary, discardPunctuation, discardCompoundToken, mode);
    }

    public JapaneseTokenizer(AttributeFactory factory, UserDictionary userDictionary, boolean discardPunctuation, Mode mode) {
        this(factory, TokenInfoDictionary.getInstance(), UnknownDictionary.getInstance(), ConnectionCosts.getInstance(), userDictionary, discardPunctuation, true, mode);
    }

    public JapaneseTokenizer(AttributeFactory factory, UserDictionary userDictionary, boolean discardPunctuation, boolean discardCompoundToken, Mode mode) {
        this(factory, TokenInfoDictionary.getInstance(), UnknownDictionary.getInstance(), ConnectionCosts.getInstance(), userDictionary, discardPunctuation, discardCompoundToken, mode);
    }

    @IgnoreRandomChains(reason="Parameters are too complex to be tested")
    public JapaneseTokenizer(AttributeFactory factory, TokenInfoDictionary systemDictionary, UnknownDictionary unkDictionary, ConnectionCosts connectionCosts, UserDictionary userDictionary, boolean discardPunctuation, boolean discardCompoundToken, Mode mode) {
        super(factory);
        boolean extendedMode;
        boolean searchMode;
        TokenInfoFST fst = systemDictionary.getFST();
        FST.BytesReader fstReader = fst.getBytesReader();
        TokenInfoFST userFST = null;
        FST.BytesReader userFSTReader = null;
        if (userDictionary != null) {
            userFST = userDictionary.getFST();
            userFSTReader = userFST.getBytesReader();
        }
        boolean outputCompounds = switch (mode.ordinal()) {
            case 1 -> {
                searchMode = true;
                extendedMode = false;
                yield !discardCompoundToken;
            }
            case 2 -> {
                searchMode = true;
                extendedMode = true;
                yield !discardCompoundToken;
            }
            default -> {
                searchMode = false;
                extendedMode = false;
                yield false;
            }
        };
        CharacterDefinition characterDefinition = unkDictionary.getCharacterDefinition();
        this.viterbi = new ViterbiNBest(fst, fstReader, systemDictionary, userFST, userFSTReader, userDictionary, connectionCosts, unkDictionary, characterDefinition, discardPunctuation, searchMode, extendedMode, outputCompounds);
        this.viterbi.resetBuffer(this.input);
        this.viterbi.resetState();
    }

    public void setGraphvizFormatter(GraphvizFormatter<JaMorphData> dotOut) {
        this.viterbi.setGraphvizFormatter(dotOut);
    }

    public void close() throws IOException {
        super.close();
        this.viterbi.resetBuffer(this.input);
    }

    public void reset() throws IOException {
        super.reset();
        this.viterbi.resetBuffer(this.input);
        this.viterbi.resetState();
        this.lastTokenPos = -1;
    }

    public void end() throws IOException {
        super.end();
        int finalOffset = this.correctOffset(this.viterbi.getPos());
        this.offsetAtt.setOffset(finalOffset, finalOffset);
    }

    public boolean incrementToken() throws IOException {
        while (this.viterbi.getPending().size() == 0) {
            if (this.viterbi.isEnd()) {
                return false;
            }
            this.viterbi.forward();
        }
        Token token = (Token)((Object)this.viterbi.getPending().remove(this.viterbi.getPending().size() - 1));
        int length = token.getLength();
        this.clearAttributes();
        assert (length > 0);
        this.termAtt.copyBuffer(token.getSurfaceForm(), token.getOffset(), length);
        this.offsetAtt.setOffset(this.correctOffset(token.getStartOffset()), this.correctOffset(token.getEndOffset()));
        this.basicFormAtt.setToken(token);
        this.posAtt.setToken(token);
        this.readingAtt.setToken(token);
        this.inflectionAtt.setToken(token);
        if (token.getStartOffset() == this.lastTokenPos) {
            this.posIncAtt.setPositionIncrement(0);
            this.posLengthAtt.setPositionLength(token.getPositionLength());
        } else if (this.viterbi.isOutputNBest()) {
            assert (token.getStartOffset() > this.lastTokenPos);
            this.posIncAtt.setPositionIncrement(1);
            this.posLengthAtt.setPositionLength(token.getPositionLength());
        } else {
            assert (token.getStartOffset() > this.lastTokenPos);
            this.posIncAtt.setPositionIncrement(1);
            this.posLengthAtt.setPositionLength(1);
        }
        this.lastTokenPos = token.getStartOffset();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int probeDelta(String inText, String requiredToken) throws IOException {
        int start = inText.indexOf(requiredToken);
        if (start < 0) {
            return -1;
        }
        int delta = Integer.MAX_VALUE;
        int saveNBestCost = this.viterbi.getNBestCost();
        this.setReader(new StringReader(inText));
        this.reset();
        try {
            this.setNBestCost(1);
            int prevRootBase = -1;
            while (this.incrementToken()) {
                if (this.viterbi.getLatticeRootBase() == prevRootBase) continue;
                prevRootBase = this.viterbi.getLatticeRootBase();
                delta = Math.min(delta, this.viterbi.probeDelta(start, start + requiredToken.length()));
            }
        }
        finally {
            this.end();
            this.close();
            this.setNBestCost(saveNBestCost);
        }
        return delta == Integer.MAX_VALUE ? -1 : delta;
    }

    public int calcNBestCost(String examples) {
        int maxDelta = 0;
        for (String example : examples.split("/")) {
            if (example.isEmpty()) continue;
            String[] pair = example.split("-");
            if (pair.length != 2) {
                throw new RuntimeException("Unexpected example form: " + example + " (expected two '-')");
            }
            try {
                maxDelta = Math.max(maxDelta, this.probeDelta(pair[0], pair[1]));
            }
            catch (IOException e) {
                throw new RuntimeException("Internal error calculating best costs from examples. Got ", e);
            }
        }
        return maxDelta;
    }

    public void setNBestCost(int value) {
        this.viterbi.setNBestCost(value);
    }

    public static enum Mode {
        NORMAL,
        SEARCH,
        EXTENDED;

    }
}

