/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.icu.segmentation;

import com.ibm.icu.lang.UCharacter;
import com.ibm.icu.text.BreakIterator;
import com.ibm.icu.text.RuleBasedBreakIterator;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import org.apache.lucene.analysis.TokenizerFactory;
import org.apache.lucene.analysis.icu.segmentation.DefaultICUTokenizerConfig;
import org.apache.lucene.analysis.icu.segmentation.ICUTokenizer;
import org.apache.lucene.analysis.icu.segmentation.ICUTokenizerConfig;
import org.apache.lucene.internal.hppc.IntObjectHashMap;
import org.apache.lucene.util.AttributeFactory;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.ResourceLoader;
import org.apache.lucene.util.ResourceLoaderAware;

public class ICUTokenizerFactory
extends TokenizerFactory
implements ResourceLoaderAware {
    public static final String NAME = "icu";
    static final String RULEFILES = "rulefiles";
    private final IntObjectHashMap<String> tailored;
    private ICUTokenizerConfig config;
    private final boolean cjkAsWords;
    private final boolean myanmarAsWords;

    public ICUTokenizerFactory(Map<String, String> args) {
        super(args);
        this.tailored = new IntObjectHashMap();
        String rulefilesArg = this.get(args, RULEFILES);
        if (rulefilesArg != null) {
            List scriptAndResourcePaths = this.splitFileNames(rulefilesArg);
            for (String scriptAndResourcePath : scriptAndResourcePaths) {
                int colonPos = scriptAndResourcePath.indexOf(58);
                String scriptCode = scriptAndResourcePath.substring(0, colonPos).trim();
                String resourcePath = scriptAndResourcePath.substring(colonPos + 1).trim();
                this.tailored.put(UCharacter.getPropertyValueEnum((int)4106, (CharSequence)scriptCode), (Object)resourcePath);
            }
        }
        this.cjkAsWords = this.getBoolean(args, "cjkAsWords", true);
        this.myanmarAsWords = this.getBoolean(args, "myanmarAsWords", true);
        if (!args.isEmpty()) {
            throw new IllegalArgumentException("Unknown parameters: " + String.valueOf(args));
        }
    }

    public ICUTokenizerFactory() {
        throw ICUTokenizerFactory.defaultCtorException();
    }

    public void inform(ResourceLoader loader) throws IOException {
        assert (this.tailored != null) : "init must be called first!";
        if (this.tailored.isEmpty()) {
            this.config = new DefaultICUTokenizerConfig(this.cjkAsWords, this.myanmarAsWords);
        } else {
            final BreakIterator[] breakers = new BreakIterator[1 + UCharacter.getIntPropertyMaxValue((int)4106)];
            for (IntObjectHashMap.IntObjectCursor entry : this.tailored) {
                int code = entry.key;
                String resourcePath = (String)entry.value;
                breakers[code] = this.parseRules(resourcePath, loader);
            }
            this.config = new DefaultICUTokenizerConfig(this, this.cjkAsWords, this.myanmarAsWords){

                @Override
                public RuleBasedBreakIterator getBreakIterator(int script) {
                    if (breakers[script] != null) {
                        return (RuleBasedBreakIterator)breakers[script].clone();
                    }
                    return super.getBreakIterator(script);
                }
            };
        }
    }

    private BreakIterator parseRules(String filename, ResourceLoader loader) throws IOException {
        StringBuilder rules = new StringBuilder();
        InputStream rulesStream = loader.openResource(filename);
        BufferedReader reader = new BufferedReader(IOUtils.getDecodingReader((InputStream)rulesStream, (Charset)StandardCharsets.UTF_8));
        String line = null;
        while ((line = reader.readLine()) != null) {
            if (!line.startsWith("#")) {
                rules.append(line);
            }
            rules.append('\n');
        }
        reader.close();
        return new RuleBasedBreakIterator(rules.toString());
    }

    public ICUTokenizer create(AttributeFactory factory) {
        assert (this.config != null) : "inform must be called first!";
        return new ICUTokenizer(factory, this.config);
    }
}

