/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.impl;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.directwebremoting.extend.WaitController;
import org.directwebremoting.impl.AbstractServerLoadMonitor;
import org.directwebremoting.util.HitMonitor;

public class ThrottlingServerLoadMonitor
extends AbstractServerLoadMonitor {
    protected static final int usageHighDisconnectedTime = 1000;
    protected static final int usageHighInitialConnectedTime = 49000;
    protected static final int usageHighFinalConnectedTime = 1000;
    protected static final int usageDiggConnectedTime = 0;
    protected static final int usageDiggMinDisconnectedTime = 2000;
    protected static final int hitOutRoundTripTime = 2000;
    protected static final int threadOutRoundTripTime = 50000;
    protected static final int roundTripAtThreadOutSeconds = 50;
    protected int maxWaitingThreads = 100;
    protected int maxHitsPerSecond = 100;
    protected int maxConnectedTime = 60000;
    protected static final int USAGE_LOW = 0;
    protected static final int USAGE_HIGH = 1;
    protected static final int USAGE_DIGG = 2;
    protected static final String[] USAGE_NAMES = new String[]{"Low", "High", "Digg"};
    protected AtomicInteger mode = new AtomicInteger(0);
    protected int connectedTime = 60000;
    protected int disconnectedTime = 1000;
    protected int secondsMonitored = 10;
    protected HitMonitor hitMonitor = new HitMonitor(this.secondsMonitored);
    protected AtomicInteger waitingThreads = new AtomicInteger(0);
    protected AtomicLong lastLoadAdjust = new AtomicLong(System.currentTimeMillis());
    protected AtomicBoolean adjusting = new AtomicBoolean(false);
    private static final Log log = LogFactory.getLog(ThrottlingServerLoadMonitor.class);

    @Override
    public boolean supportsStreaming() {
        return true;
    }

    @Override
    public long getConnectedTime() {
        return this.connectedTime;
    }

    @Override
    public int getDisconnectedTime() {
        return this.disconnectedTime;
    }

    @Override
    public void threadWaitStarting(WaitController controller) {
        super.threadWaitStarting(controller);
        this.hitMonitor.recordHit();
        int currentWaitingThreads = this.waitingThreads.incrementAndGet();
        if (!this.adjusting.getAndSet(true)) {
            this.loadAdjust(currentWaitingThreads);
            this.adjusting.set(false);
        }
    }

    @Override
    public void threadWaitEnding(WaitController controller) {
        super.threadWaitEnding(controller);
        this.waitingThreads.decrementAndGet();
    }

    private void debug(Object o) {
        if (log.isDebugEnabled()) {
            log.debug(o);
        }
    }

    private void loadAdjust(int currentWaitingThreads) {
        if (System.currentTimeMillis() - this.lastLoadAdjust.get() < (long)(this.secondsMonitored / 2)) {
            return;
        }
        if (currentWaitingThreads < this.maxWaitingThreads) {
            this.changeMode(0, this.maxConnectedTime, this.disconnectedTime);
            return;
        }
        float hitsPerSecond = (float)this.hitMonitor.getHitsInLastPeriod() / (float)this.secondsMonitored;
        int hitsPerSecondAtThreadOut = this.maxWaitingThreads / 50;
        int hitsPerSecondAtHitOut = this.maxHitsPerSecond;
        this.debug("Hits per second: " + hitsPerSecond);
        this.debug("Hits per second at ThreadOut: " + hitsPerSecondAtThreadOut);
        this.debug("Hits per second at HitOut: " + hitsPerSecondAtHitOut);
        if (hitsPerSecond < (float)hitsPerSecondAtThreadOut) {
            this.changeMode(1, this.connectedTime, this.disconnectedTime);
            return;
        }
        float load = hitsPerSecond / (float)this.maxHitsPerSecond;
        int loadBasedDisconnectedTime = (int)((float)this.disconnectedTime * load);
        if (this.mode.get() == 2) {
            this.changeMode(2, 0, loadBasedDisconnectedTime);
            if (this.disconnectedTime > 2000) {
                return;
            }
        }
        if (hitsPerSecond < (float)hitsPerSecondAtHitOut) {
            float factor = (float)currentWaitingThreads / (float)this.maxWaitingThreads;
            int tmpConnectedTime = (int)((float)this.connectedTime / factor);
            if (tmpConnectedTime > 49000) {
                tmpConnectedTime = 49000;
            } else if (tmpConnectedTime < 1000) {
                tmpConnectedTime = 1000;
            }
            this.changeMode(1, tmpConnectedTime, 1000);
            return;
        }
        if (loadBasedDisconnectedTime < 2000) {
            this.changeMode(2, 0, 2000);
        } else {
            this.changeMode(2, 0, loadBasedDisconnectedTime);
        }
    }

    private void changeMode(int usageMode, int _connectedTime, int _disconnectedTime) {
        this.connectedTime = _connectedTime;
        this.disconnectedTime = _disconnectedTime;
        this.setMode(usageMode);
    }

    protected void setMode(int newMode) {
        int currentMode = this.mode.getAndSet(newMode);
        if (newMode != currentMode) {
            this.debug("Changing modes, from " + USAGE_NAMES[currentMode] + " to " + USAGE_NAMES[newMode]);
        }
    }

    protected int getMode() {
        return this.mode.get();
    }

    public void setMaxWaitingThreads(int maxWaitingThreads) {
        this.maxWaitingThreads = maxWaitingThreads;
    }

    public void setMaxHitsPerSecond(int maxHitsPerSecond) {
        this.maxHitsPerSecond = maxHitsPerSecond;
    }

    void setMaxConnectedTime(int maxConnectedTime) {
        this.maxConnectedTime = maxConnectedTime;
    }
}

