/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.export;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.directwebremoting.Browser;
import org.directwebremoting.datasync.Directory;
import org.directwebremoting.datasync.StoreProvider;
import org.directwebremoting.io.DwrConvertedException;
import org.directwebremoting.io.Item;
import org.directwebremoting.io.ItemUpdate;
import org.directwebremoting.io.MatchedItems;
import org.directwebremoting.io.StoreChangeListener;
import org.directwebremoting.io.StoreRegion;

public class Data {
    private static final Log log = LogFactory.getLog(Data.class);

    public Item viewItem(String storeId, String itemId, StoreChangeListener<Object> listener) {
        StoreProvider<Object> provider = Directory.getRegistration(storeId, Object.class);
        if (provider == null) {
            throw new DwrConvertedException("clientId not found");
        }
        if (listener != null) {
            return provider.viewItem(itemId, listener);
        }
        return provider.viewItem(itemId);
    }

    public MatchedItems viewRegion(String storeId, StoreRegion region, StoreChangeListener<Object> listener) {
        StoreProvider<Object> provider = Directory.getRegistration(storeId, Object.class);
        if (provider == null) {
            throw new DwrConvertedException("clientId not found");
        }
        if (region == null) {
            region = new StoreRegion();
        }
        if (listener != null) {
            provider.unsubscribe(listener);
            return provider.viewRegion(region, listener);
        }
        return provider.viewRegion(region);
    }

    public void unsubscribe(String storeId, StoreChangeListener<Object> receiver) {
        StoreProvider<Object> provider = Directory.getRegistration(storeId, Object.class);
        provider.unsubscribe(receiver);
        Browser.close(receiver);
    }

    public <T> void update(String storeId, List<ItemUpdate> changes) {
        StoreProvider<Object> store = Directory.getRegistration(storeId, Object.class);
        if (store == null) {
            log.error((Object)("update() can't find any stores with storeId=" + storeId));
            throw new NullPointerException("Invalid store");
        }
        store.update(changes);
    }
}

