/*
 * Decompiled with CFR 0.152.
 */
package org.xmpp.packet;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.Weigher;
import gnu.inet.encoding.IDNA;
import gnu.inet.encoding.Stringprep;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import net.jcip.annotations.Immutable;
import org.xmpp.util.JIDWeigher;
import org.xmpp.util.ValueWrapper;

@Immutable
public class JID
implements Comparable<JID>,
Serializable {
    private static final long serialVersionUID = 8135170608402192877L;
    public static final Cache<String, ValueWrapper<String>> NODEPREP_CACHE = Caffeine.newBuilder().weigher((Weigher)new JIDWeigher()).maximumWeight(1000000L).expireAfterWrite(Duration.ofMinutes(30L)).recordStats().build();
    public static final Cache<String, ValueWrapper<String>> DOMAINPREP_CACHE = Caffeine.newBuilder().weigher((Weigher)new JIDWeigher()).maximumWeight(50000L).expireAfterWrite(Duration.ofMinutes(30L)).recordStats().build();
    public static final Cache<String, ValueWrapper<String>> RESOURCEPREP_CACHE = Caffeine.newBuilder().weigher((Weigher)new JIDWeigher()).maximumWeight(1000000L).expireAfterWrite(Duration.ofMinutes(30L)).recordStats().build();
    private final String node;
    private final String domain;
    private final String resource;

    public static String escapeNode(String node) {
        if (node == null) {
            return null;
        }
        StringBuilder buf = new StringBuilder(node.length() + 8);
        int n = node.length();
        block11: for (int i = 0; i < n; ++i) {
            char c = node.charAt(i);
            switch (c) {
                case '\"': {
                    buf.append("\\22");
                    continue block11;
                }
                case '&': {
                    buf.append("\\26");
                    continue block11;
                }
                case '\'': {
                    buf.append("\\27");
                    continue block11;
                }
                case '/': {
                    buf.append("\\2f");
                    continue block11;
                }
                case ':': {
                    buf.append("\\3a");
                    continue block11;
                }
                case '<': {
                    buf.append("\\3c");
                    continue block11;
                }
                case '>': {
                    buf.append("\\3e");
                    continue block11;
                }
                case '@': {
                    buf.append("\\40");
                    continue block11;
                }
                case '\\': {
                    int c3;
                    int c2 = i + 1 < n ? (int)node.charAt(i + 1) : -1;
                    int n2 = c3 = i + 2 < n ? (int)node.charAt(i + 2) : -1;
                    if (c2 == 50 && (c3 == 48 || c3 == 50 || c3 == 54 || c3 == 55 || c3 == 102) || c2 == 51 && (c3 == 97 || c3 == 99 || c3 == 101) || c2 == 52 && c3 == 48 || c2 == 53 && c3 == 99) {
                        buf.append("\\5c");
                        continue block11;
                    }
                    buf.append(c);
                    continue block11;
                }
                default: {
                    if (Character.isWhitespace(c)) {
                        buf.append("\\20");
                        continue block11;
                    }
                    buf.append(c);
                }
            }
        }
        return buf.toString();
    }

    public static String unescapeNode(String node) {
        if (node == null) {
            return null;
        }
        char[] nodeChars = node.toCharArray();
        StringBuilder buf = new StringBuilder(nodeChars.length);
        int n = nodeChars.length;
        block12: for (int i = 0; i < n; ++i) {
            char c = node.charAt(i);
            if (c == '\\' && i + 2 < n) {
                char c2 = nodeChars[i + 1];
                char c3 = nodeChars[i + 2];
                if (c2 == '2') {
                    switch (c3) {
                        case '0': {
                            buf.append(' ');
                            i += 2;
                            continue block12;
                        }
                        case '2': {
                            buf.append('\"');
                            i += 2;
                            continue block12;
                        }
                        case '6': {
                            buf.append('&');
                            i += 2;
                            continue block12;
                        }
                        case '7': {
                            buf.append('\'');
                            i += 2;
                            continue block12;
                        }
                        case 'f': {
                            buf.append('/');
                            i += 2;
                            continue block12;
                        }
                    }
                } else if (c2 == '3') {
                    switch (c3) {
                        case 'a': {
                            buf.append(':');
                            i += 2;
                            continue block12;
                        }
                        case 'c': {
                            buf.append('<');
                            i += 2;
                            continue block12;
                        }
                        case 'e': {
                            buf.append('>');
                            i += 2;
                            continue block12;
                        }
                    }
                } else if (c2 == '4') {
                    if (c3 == '0') {
                        buf.append("@");
                        i += 2;
                        continue;
                    }
                } else if (c2 == '5' && c3 == 'c') {
                    buf.append("\\");
                    i += 2;
                    continue;
                }
            }
            buf.append(c);
        }
        return buf.toString();
    }

    public static String nodeprep(String node) {
        if (node == null) {
            return null;
        }
        ValueWrapper cachedResult = (ValueWrapper)NODEPREP_CACHE.get((Object)node, k -> {
            try {
                String answer = Stringprep.nodeprep((String)k);
                if (answer.getBytes(StandardCharsets.UTF_8).length > 1023) {
                    return new ValueWrapper(new IllegalArgumentException("Node cannot be larger than 1023 bytes (after nodeprepping). Size is " + answer.getBytes(StandardCharsets.UTF_8).length + " bytes."));
                }
                if (answer.equals(node)) {
                    return new ValueWrapper();
                }
                return new ValueWrapper<String>(answer);
            }
            catch (Exception ex) {
                return new ValueWrapper(ex);
            }
        });
        assert (cachedResult != null);
        switch (cachedResult.getRepresentation()) {
            case USE_KEY: {
                return node;
            }
            case USE_VALUE: {
                return (String)cachedResult.getValue();
            }
            case ILLEGAL: {
                throw new IllegalArgumentException("The input '" + node + "' is not a valid JID node part: " + cachedResult.getExceptionMessage());
            }
        }
        throw new IllegalStateException("The implementation of JID#nodeprep(String) is broken.");
    }

    public static String domainprep(String domain) {
        if (domain == null) {
            throw new IllegalArgumentException("Argument 'domain' cannot be null.");
        }
        ValueWrapper cachedResult = (ValueWrapper)DOMAINPREP_CACHE.get((Object)domain, k -> {
            try {
                String answer = Stringprep.nameprep((String)IDNA.toASCII((String)k), (boolean)false);
                if (answer.getBytes(StandardCharsets.UTF_8).length > 1023) {
                    return new ValueWrapper(new IllegalArgumentException("Domain cannot be larger than 1023 bytes (after nameprepping). Size is " + answer.getBytes(StandardCharsets.UTF_8).length + " bytes."));
                }
                if (answer.equals(domain)) {
                    return new ValueWrapper();
                }
                return new ValueWrapper<String>(answer);
            }
            catch (Exception ex) {
                return new ValueWrapper(ex);
            }
        });
        assert (cachedResult != null);
        switch (cachedResult.getRepresentation()) {
            case USE_KEY: {
                return domain;
            }
            case USE_VALUE: {
                return (String)cachedResult.getValue();
            }
            case ILLEGAL: {
                throw new IllegalArgumentException("The input '" + domain + "' is not a valid JID domain part: " + cachedResult.getExceptionMessage());
            }
        }
        throw new IllegalStateException("The implementation of JID#domainprep(String) is broken.");
    }

    public static String resourceprep(String resource) {
        if (resource == null) {
            return null;
        }
        ValueWrapper cachedResult = (ValueWrapper)RESOURCEPREP_CACHE.get((Object)resource, k -> {
            try {
                String answer = Stringprep.resourceprep((String)resource);
                if (answer.getBytes(StandardCharsets.UTF_8).length > 1023) {
                    return new ValueWrapper(new IllegalArgumentException("Resource cannot be larger than 1023 bytes (after resourceprepping). Size is " + answer.getBytes(StandardCharsets.UTF_8).length + " bytes."));
                }
                if (answer.equals(resource)) {
                    return new ValueWrapper();
                }
                return new ValueWrapper<String>(answer);
            }
            catch (Exception ex) {
                return new ValueWrapper(ex);
            }
        });
        assert (cachedResult != null);
        switch (cachedResult.getRepresentation()) {
            case USE_KEY: {
                return resource;
            }
            case USE_VALUE: {
                return (String)cachedResult.getValue();
            }
            case ILLEGAL: {
                throw new IllegalArgumentException("The input '" + resource + "' is not a valid JID resource part: " + cachedResult.getExceptionMessage());
            }
        }
        throw new IllegalStateException("The implementation of JID#resourceprep(String) is broken.");
    }

    public JID(String jid) {
        this(JID.getParts(jid), false);
    }

    public JID(String jid, boolean skipStringPrep) {
        this(JID.getParts(jid), skipStringPrep);
    }

    private JID(String[] parts, boolean skipStringPrep) {
        this(parts[0], parts[1], parts[2], skipStringPrep);
    }

    public JID(String node, String domain, String resource) {
        this(node, domain, resource, false);
    }

    public JID(String node, String domain, String resource, boolean skipStringprep) {
        if (domain == null) {
            throw new NullPointerException("Domain cannot be null");
        }
        if (skipStringprep) {
            this.node = node;
            this.domain = domain;
            this.resource = resource;
        } else {
            if (node != null && node.equals("")) {
                node = null;
            }
            if (resource != null && resource.equals("")) {
                resource = null;
            }
            try {
                this.node = JID.nodeprep(node);
                this.domain = JID.domainprep(domain);
                this.resource = JID.resourceprep(resource);
            }
            catch (Exception e) {
                StringBuilder buf = new StringBuilder();
                if (node != null) {
                    buf.append(node).append("@");
                }
                buf.append(domain);
                if (resource != null) {
                    buf.append("/").append(resource);
                }
                throw new IllegalArgumentException("Illegal JID: " + buf, e);
            }
        }
    }

    static String[] getParts(String jid) {
        if (jid == null) {
            throw new IllegalArgumentException("Argument cannot be null.");
        }
        int slashIndex = jid.indexOf("/");
        int atIndex = jid.indexOf("@");
        if (slashIndex > -1 && atIndex > slashIndex) {
            atIndex = -1;
        }
        if (atIndex == 0) {
            throw new IllegalArgumentException("Existing at-character at the first character of the string indicates that an empty node part is provided. This is illegal. Offending value: '" + jid + "'");
        }
        if (slashIndex == jid.length() - 1) {
            throw new IllegalArgumentException("Existing slash at the very end of the string indicates that an empty resource part is provided. This is illegal. Offending value: '" + jid + "'");
        }
        String node = null;
        if (atIndex > 0) {
            node = jid.substring(0, atIndex);
        }
        if (atIndex + 1 > jid.length()) {
            throw new IllegalArgumentException("JID with empty domain not valid. Offending value: '" + jid + "'");
        }
        String domain = atIndex < 0 ? (slashIndex > 0 ? jid.substring(0, slashIndex) : jid) : (slashIndex > 0 ? jid.substring(atIndex + 1, slashIndex) : jid.substring(atIndex + 1));
        String resource = slashIndex + 1 > jid.length() || slashIndex < 0 ? null : jid.substring(slashIndex + 1);
        String[] parts = new String[]{node, domain, resource};
        return parts;
    }

    public String getNode() {
        return this.node;
    }

    public String getDomain() {
        return this.domain;
    }

    public String getResource() {
        return this.resource;
    }

    public String toBareJID() {
        StringBuilder sb = new StringBuilder();
        if (this.node != null) {
            sb.append(this.node);
            sb.append('@');
        }
        sb.append(this.domain);
        return sb.toString();
    }

    public JID asBareJID() {
        return new JID(this.node, this.domain, null, true);
    }

    public String toFullJID() {
        if (this.resource == null) {
            throw new IllegalStateException("This JID was instantiated without a resource identifier. A full JID representation is not available for: " + this);
        }
        StringBuilder sb = new StringBuilder();
        if (this.node != null) {
            sb.append(this.node);
            sb.append('@');
        }
        sb.append(this.domain);
        sb.append('/');
        sb.append(this.resource);
        return sb.toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.node != null) {
            sb.append(this.node);
            sb.append('@');
        }
        sb.append(this.domain);
        if (this.resource != null) {
            sb.append('/');
            sb.append(this.resource);
        }
        return sb.toString();
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object object) {
        if (!(object instanceof JID)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        JID jid = (JID)object;
        if (this.node != null ? !this.node.equals(jid.node) : jid.node != null) {
            return false;
        }
        if (!this.domain.equals(jid.domain)) {
            return false;
        }
        if (this.resource != null) {
            return this.resource.equals(jid.resource);
        }
        return jid.resource == null;
    }

    @Override
    public int compareTo(JID jid) {
        int compare = this.domain.compareTo(jid.domain);
        if (compare == 0) {
            String myNode = this.node != null ? this.node : "";
            String hisNode = jid.node != null ? jid.node : "";
            compare = myNode.compareTo(hisNode);
        }
        if (compare == 0) {
            String myResource = this.resource != null ? this.resource : "";
            String hisResource = jid.resource != null ? jid.resource : "";
            compare = myResource.compareTo(hisResource);
        }
        return compare;
    }

    public static boolean equals(String jid1, String jid2) {
        return new JID(jid1).equals(new JID(jid2));
    }
}

