/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.routing.oracle;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import oracle.jdbc.OracleShardingKey;
import oracle.jdbc.OracleShardingKeyBuilder;
import oracle.jdbc.clio.annotations.Debug;
import oracle.jdbc.diagnostics.SecurityLabel;
import oracle.jdbc.pool.OracleDataSource;
import oracle.jdbc.pool.OracleShardingKeyBuilderImpl;
import oracle.ons.ONS;
import oracle.ucp.ConnectionRetrievalInfo;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.common.ONSDriver;
import oracle.ucp.common.Service;
import oracle.ucp.common.ServiceMember;
import oracle.ucp.diagnostics.Diagnosable;
import oracle.ucp.diagnostics.DiagnosticsCollectorImpl;
import oracle.ucp.jdbc.JDBCConnectionRetrievalInfo;
import oracle.ucp.routing.Chunk;
import oracle.ucp.routing.ChunkEventHandler;
import oracle.ucp.routing.ChunkInfo;
import oracle.ucp.routing.ShardInfo;
import oracle.ucp.routing.ShardRoutingCache;
import oracle.ucp.routing.oracle.ChunkInfoImpl;
import oracle.ucp.util.UCPErrorHandler;

public class OracleShardRoutingCache
extends ShardRoutingCache {
    static final String CLASS_NAME = OracleShardRoutingCache.class.getName();
    public static final String USER = "user";
    public static final String PASSWORD = "password";
    public static final String URL = "url";
    public static final String REGION = "region";
    public static final String SERVICE_NAME = "serviceName";
    private Properties dataSourceProperties = null;

    OracleShardRoutingCache(final ONS ons, Diagnosable diagnosticsCollector) throws UniversalConnectionPoolException {
        super(diagnosticsCollector);
        ONSDriver onsDriver = new ONSDriver(){

            protected ONS getONS() throws UniversalConnectionPoolException {
                return ons;
            }
        };
        this.startEventHandler(onsDriver);
    }

    OracleShardRoutingCache(ONS ons) throws UniversalConnectionPoolException {
        this(ons, (Diagnosable)DiagnosticsCollectorImpl.getCommon());
    }

    public OracleShardRoutingCache(Properties dataSourceProps, Diagnosable diagnosticsCollector) throws UniversalConnectionPoolException {
        super(diagnosticsCollector);
        if (dataSourceProps == null) {
            throw new IllegalArgumentException("Invalid datasource properties provided");
        }
        String serviceName = dataSourceProps.getProperty(SERVICE_NAME, null);
        if (serviceName == null) {
            throw new IllegalStateException("Service name must be set on datasource properties.");
        }
        this.dataSourceProperties = dataSourceProps;
        try (Connection conn = this.getConnectionFromDatasource();){
            this.initializeCache(conn);
        }
        catch (SQLException ex) {
            this.trace(Level.WARNING, CLASS_NAME, "OracleShardRoutingCache<init>", "Error occured while closing connection = {0}", null, ex, ex.getMessage());
        }
    }

    public OracleShardRoutingCache(Properties dataSourceProps) throws UniversalConnectionPoolException {
        this(dataSourceProps, (Diagnosable)DiagnosticsCollectorImpl.getCommon());
    }

    /*
     * WARNING - void declaration
     */
    @Debug(level=Debug.Level.FINEST)
    public void initializeCache(Connection connection) throws UniversalConnectionPoolException {
        try {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.routing.oracle.OracleShardRoutingCache", "initializeCache", "entering args ({0})", null, null, connection);
            String serviceName = this.dataSourceProperties.getProperty(SERVICE_NAME);
            try {
                void conn;
                String onsConfStr = this.getOnsConfig((Connection)conn, this.dataSourceProperties.getProperty(REGION));
                if (onsConfStr != null) {
                    ONSDriver onsDrvr = ONSDriver.instance();
                    onsDrvr.start(onsConfStr);
                    this.startEventHandler(onsDrvr);
                }
                this.shardingMetadata.compareAndSet(null, this.fetchShardingMetadata((Connection)conn, serviceName));
                this.buildTopologyForInstance((Connection)conn, serviceName);
                if (this.getRoutingTableSize() == 0) {
                    UCPErrorHandler.throwUniversalConnectionPoolException(280);
                }
            }
            catch (SQLException e) {
                throw new UniversalConnectionPoolException(e);
            }
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.routing.oracle.OracleShardRoutingCache", "initializeCache", "returning void", null, null, new Object[0]);
            return;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.routing.oracle.OracleShardRoutingCache", "initializeCache", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    @Override
    protected PreparedStatement prepareStatementForChunkMetaData(Connection oConn, String serviceName) throws SQLException {
        boolean isMultipleTableFamilySupported = this.multipleTableFamilySupported(oConn);
        String regionName = this.dataSourceProperties != null ? this.dataSourceProperties.getProperty(REGION, null) : null;
        String regionCaluse = regionName != null ? " and (s.locality = 0 OR (s.locality = 1 AND d.region_name = ?))" : "";
        String sql = isMultipleTableFamilySupported ? "SELECT c.CHUNK_NAME, c.SHARD_KEY_LOW, c.SHARD_KEY_HIGH, c.GROUP_KEY_LOW, c.GROUP_KEY_HIGH, c.PRIORITY, c.INST_ID, c.CHUNK_ID, c.SHARD_NAME, c.CHUNK_UNIQUE_ID from local_chunks c, gsmadmin_internal.service s, gsmadmin_internal.sha_databases d, local_table_family_services tfs where tfs.SERVICE_NAME=? and s.network_name = tfs.service_name and c.shard_name = d.db_unique_name and d.db_up = 'Y' and ((S.ROLE IS NULL) OR S.ROLE = 0 OR (S.ROLE=1 AND D.IS_PRIMARY='Y') OR (S.ROLE IN (2,3,4) AND D.IS_PRIMARY='N'))" + regionCaluse + " and SHARD_KEY_LOW is not NULL and SHARD_KEY_HIGH is not NULL  and CHUNK_NAME is not NULL" : "SELECT c.CHUNK_NAME, c.SHARD_KEY_LOW, c.SHARD_KEY_HIGH, c.GROUP_KEY_LOW, c.GROUP_KEY_HIGH, c.PRIORITY, c.INST_ID, c.CHUNK_ID, c.SHARD_NAME, c.CHUNK_UNIQUE_ID from local_chunks c, gsmadmin_internal.service s, gsmadmin_internal.sha_databases d where s.network_name = ? and c.shard_name = d.db_unique_name and d.db_up = 'Y' and ((S.ROLE IS NULL) OR S.ROLE = 0 OR (S.ROLE=1 AND D.IS_PRIMARY='Y') OR (S.ROLE IN (2,3,4) AND D.IS_PRIMARY='N'))" + regionCaluse + " and SHARD_KEY_LOW is not NULL and SHARD_KEY_HIGH is not NULL and CHUNK_NAME is not NULL";
        PreparedStatement ps = oConn.prepareStatement(sql);
        ps.setString(1, serviceName);
        if (regionName != null) {
            ps.setString(2, regionName);
        }
        return ps;
    }

    @Debug(level=Debug.Level.FINEST)
    private Connection getConnectionFromDatasource() throws UniversalConnectionPoolException {
        try {
            Connection connection;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.routing.oracle.OracleShardRoutingCache", "getConnectionFromDatasource", "entering args ()", null, null, new Object[0]);
            try {
                OracleDataSource datasource = new OracleDataSource();
                String url = this.dataSourceProperties.getProperty(URL);
                datasource.setURL(url);
                datasource.setConnectionProperties(this.dataSourceProperties);
                connection = datasource.getConnection();
            }
            catch (SQLException ex) {
                throw new UniversalConnectionPoolException(ex);
            }
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.routing.oracle.OracleShardRoutingCache", "getConnectionFromDatasource", "returning {0}", null, null, connection);
            return connection;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.routing.oracle.OracleShardRoutingCache", "getConnectionFromDatasource", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    /*
     * Exception decompiling
     */
    @Debug(level=Debug.Level.FINEST)
    private String getOnsConfig(Connection var1_1, String var2_2) throws UniversalConnectionPoolException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Debug(level=Debug.Level.FINEST)
    public OracleShardingKeyBuilder getShardingKeyBuilder() throws UniversalConnectionPoolException {
        try {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.routing.oracle.OracleShardRoutingCache", "getShardingKeyBuilder", "entering args ()", null, null, new Object[0]);
            OracleShardingKeyBuilderImpl oracleShardingKeyBuilderImpl = new OracleShardingKeyBuilderImpl();
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.routing.oracle.OracleShardRoutingCache", "getShardingKeyBuilder", "returning {0}", null, null, oracleShardingKeyBuilderImpl);
            return oracleShardingKeyBuilderImpl;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.routing.oracle.OracleShardRoutingCache", "getShardingKeyBuilder", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Debug(level=Debug.Level.FINEST)
    public void reloadCache(Properties properties) throws UniversalConnectionPoolException {
        try {
            void dataSourceProps;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.routing.oracle.OracleShardRoutingCache", "reloadCache", "entering args ({0})", null, null, properties);
            this.destroy();
            if (dataSourceProps == null) {
                throw new IllegalArgumentException("Invalid datasource properties provided");
            }
            String serviceName = dataSourceProps.getProperty(SERVICE_NAME, null);
            if (serviceName == null) {
                throw new IllegalStateException("Service name must be set on datasource properties.");
            }
            this.dataSourceProperties = dataSourceProps;
            try (Connection conn = this.getConnectionFromDatasource();){
                this.initializeCache(conn);
            }
            catch (SQLException ex) {
                this.trace(Level.WARNING, CLASS_NAME, "reloadCache", "Error occured while closing connection = {0}", null, ex, ex.getMessage());
            }
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.routing.oracle.OracleShardRoutingCache", "reloadCache", "returning void", null, null, new Object[0]);
            return;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.routing.oracle.OracleShardRoutingCache", "reloadCache", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Debug(level=Debug.Level.FINEST)
    Set<ServiceMember> getInstancesForShardKey(JDBCConnectionRetrievalInfo jDBCConnectionRetrievalInfo) {
        try {
            void cri;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.routing.oracle.OracleShardRoutingCache", "getInstancesForShardKey", "entering args ({0})", null, null, jDBCConnectionRetrievalInfo);
            HashSet<ServiceMember> instances = new HashSet<ServiceMember>();
            this.chunks((ConnectionRetrievalInfo)cri).stream().forEach(chunk -> instances.addAll(chunk.instances()));
            HashSet<ServiceMember> hashSet = instances;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.routing.oracle.OracleShardRoutingCache", "getInstancesForShardKey", "returning {0}", null, null, hashSet);
            return hashSet;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.routing.oracle.OracleShardRoutingCache", "getInstancesForShardKey", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Debug(level=Debug.Level.FINEST)
    public Set<ShardInfo> getShardInfoForKey(OracleShardingKey oracleShardingKey, OracleShardingKey oracleShardingKey2) {
        try {
            void key;
            void superKey;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.routing.oracle.OracleShardRoutingCache", "getShardInfoForKey", "entering args ({0}, {1})", null, null, oracleShardingKey, oracleShardingKey2);
            HashSet<ShardInfo> shardInfo = new HashSet<ShardInfo>();
            this.chunks((OracleShardingKey)superKey, this.computeLookupKey((OracleShardingKey)key)).forEach(chunk -> shardInfo.addAll(chunk.shardInfo()));
            HashSet<ShardInfo> hashSet = shardInfo;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.routing.oracle.OracleShardRoutingCache", "getShardInfoForKey", "returning {0}", null, null, hashSet);
            return hashSet;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.routing.oracle.OracleShardRoutingCache", "getShardInfoForKey", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Debug(level=Debug.Level.FINEST)
    public ChunkInfo getChunkInfoForKey(OracleShardingKey oracleShardingKey, OracleShardingKey oracleShardingKey2) {
        try {
            void key;
            void superKey;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.routing.oracle.OracleShardRoutingCache", "getChunkInfoForKey", "entering args ({0}, {1})", null, null, oracleShardingKey, oracleShardingKey2);
            List<Chunk> chunkList = this.chunks((OracleShardingKey)superKey, this.computeLookupKey((OracleShardingKey)key));
            if (!chunkList.isEmpty()) {
                Chunk chunk = chunkList.get(0);
                int chunkUniqueId = chunk.getUniqueId();
                ChunkInfoImpl chunkInfoImpl = new ChunkInfoImpl(chunkUniqueId, chunk.shardInfo());
                this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.routing.oracle.OracleShardRoutingCache", "getChunkInfoForKey", "returning {0}", null, null, chunkInfoImpl);
                return chunkInfoImpl;
            }
            ChunkInfo chunkInfo = null;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.routing.oracle.OracleShardRoutingCache", "getChunkInfoForKey", "returning {0}", null, null, chunkInfo);
            return chunkInfo;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.routing.oracle.OracleShardRoutingCache", "getChunkInfoForKey", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Debug(level=Debug.Level.FINEST)
    private List<Chunk> chunks(ConnectionRetrievalInfo connectionRetrievalInfo) {
        try {
            void cri;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.routing.oracle.OracleShardRoutingCache", "chunks", "entering args ({0})", null, null, connectionRetrievalInfo);
            if (!(cri instanceof JDBCConnectionRetrievalInfo)) {
                ArrayList<Chunk> arrayList = new ArrayList<Chunk>();
                this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.routing.oracle.OracleShardRoutingCache", "chunks", "returning {0}", null, null, arrayList);
                return arrayList;
            }
            JDBCConnectionRetrievalInfo jdbcCri = (JDBCConnectionRetrievalInfo)cri;
            List<Chunk> list = this.chunks(jdbcCri.getSuperShardingKey(), this.computeLookupKey(jdbcCri.getShardingKey()));
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.routing.oracle.OracleShardRoutingCache", "chunks", "returning {0}", null, null, list);
            return list;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.routing.oracle.OracleShardRoutingCache", "chunks", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    @Override
    @Debug(level=Debug.Level.FINEST)
    protected ChunkEventHandler prepareChunkEventHandler() {
        try {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.routing.oracle.OracleShardRoutingCache", "prepareChunkEventHandler", "entering args ()", null, null, new Object[0]);
            ChunkEventHandler chunkEventHandler = new ChunkEventHandler(DiagnosticsCollectorImpl.getCommon()){

                @Override
                protected void onEvent(ChunkEventHandler.Event event) {
                    if (OracleShardRoutingCache.this.dataSourceProperties != null) {
                        OracleShardRoutingCache.this.clearCache();
                        try (Connection conn = OracleShardRoutingCache.this.getConnectionFromDatasource();){
                            OracleShardRoutingCache.this.buildTopologyForInstance(conn, OracleShardRoutingCache.this.dataSourceProperties.getProperty(OracleShardRoutingCache.SERVICE_NAME));
                        }
                        catch (SQLException ex) {
                            this.trace(Level.WARNING, CLASS_NAME, "onEvent", "Error occured while processing ons event = {0}", null, ex, ex.getMessage());
                        }
                        catch (UniversalConnectionPoolException upEx) {
                            this.trace(Level.WARNING, CLASS_NAME, "onEvent", "Error occured while processing ons event = {0}", null, upEx, upEx.getMessage());
                        }
                    }
                }
            };
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.routing.oracle.OracleShardRoutingCache", "prepareChunkEventHandler", "returning {0}", null, null, chunkEventHandler);
            return chunkEventHandler;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.routing.oracle.OracleShardRoutingCache", "prepareChunkEventHandler", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    @Override
    protected boolean isMaxPerShardReached(ServiceMember member) {
        return false;
    }

    @Override
    protected Service service() {
        return null;
    }

    @Override
    public void destroy() {
        super.destroy();
    }
}

