/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.jdbc.proxy.other;

import java.lang.reflect.Method;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLRecoverableException;
import java.sql.Statement;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import javax.sql.ConnectionEventListener;
import javax.sql.StatementEventListener;
import javax.sql.XAConnection;
import oracle.ucp.AbandonedConnectionTimeoutCallback;
import oracle.ucp.ConnectionHarvestingCallback;
import oracle.ucp.TimeToLiveConnectionTimeoutCallback;
import oracle.ucp.UniversalConnectionPool;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.UniversalPooledConnection;
import oracle.ucp.UniversalPooledConnectionStatus;
import oracle.ucp.common.UniversalConnectionPoolBase;
import oracle.ucp.diagnostics.Diagnosable;
import oracle.ucp.jdbc.ConnectionWithAbandonedTimeout;
import oracle.ucp.jdbc.ConnectionWithTimeToLiveTimeout;
import oracle.ucp.jdbc.HarvestableConnection;
import oracle.ucp.jdbc.LabelableConnection;
import oracle.ucp.jdbc.ValidConnection;
import oracle.ucp.jdbc.proxy.Creator;
import oracle.ucp.jdbc.proxy.LogicalObject;
import oracle.ucp.jdbc.proxy.ProxyException;
import oracle.ucp.jdbc.proxy.other.StatementProxy;
import oracle.ucp.proxy.annotation.GetCreator;
import oracle.ucp.proxy.annotation.GetDelegate;
import oracle.ucp.proxy.annotation.Methods;
import oracle.ucp.proxy.annotation.OnError;
import oracle.ucp.proxy.annotation.Post;
import oracle.ucp.proxy.annotation.Pre;
import oracle.ucp.proxy.annotation.ProxyFor;
import oracle.ucp.proxy.annotation.ProxyResult;
import oracle.ucp.proxy.annotation.ProxyResultPolicy;
import oracle.ucp.proxy.annotation.Signature;
import oracle.ucp.util.ArrayChain;
import oracle.ucp.util.Chain;
import oracle.ucp.util.UCPErrorHandler;

@ProxyFor(value={Connection.class, XAConnection.class})
@ProxyResult(value=ProxyResultPolicy.CREATE)
public abstract class ConnectionProxy
implements LabelableConnection,
HarvestableConnection,
ConnectionWithAbandonedTimeout,
ConnectionWithTimeToLiveTimeout,
ValidConnection,
XAConnection,
LogicalObject,
Diagnosable {
    static final String CLASS_NAME = ConnectionProxy.class.getName();
    final AtomicBoolean closed = new AtomicBoolean(false);
    protected final AtomicBoolean actuallyReturned = new AtomicBoolean(false);
    protected final Chain<StatementProxy> statementsToClose = new ArrayChain<StatementProxy>();
    private volatile UniversalPooledConnection proxiedPooledConnection = null;
    private volatile UniversalConnectionPool proxiedPool = null;

    UniversalPooledConnection getUPC() {
        Object c;
        UniversalPooledConnection upc = this.proxiedPooledConnection;
        if (null == upc && null != (c = this.getCreator())) {
            this.proxiedPooledConnection = c instanceof Creator ? ((Creator)c).getUPC() : ((ConnectionProxy)c).getUPC();
            upc = this.proxiedPooledConnection;
        }
        return upc;
    }

    UniversalConnectionPool getUCP() {
        Object c;
        UniversalConnectionPool ucp = this.proxiedPool;
        if (null == ucp && null != (c = this.getCreator())) {
            this.proxiedPool = c instanceof Creator ? ((Creator)c).getUCP() : ((ConnectionProxy)c).getUCP();
            ucp = this.proxiedPool;
        }
        return ucp;
    }

    @GetDelegate
    protected abstract Connection getDelegate();

    @GetCreator
    protected abstract Object getCreator();

    @Pre
    @Methods(signatures={@Signature(name="addConnectionEventListener", args={ConnectionEventListener.class}), @Signature(name="addStatementEventListener", args={StatementEventListener.class}), @Signature(name="removeConnectionEventListener", args={ConnectionEventListener.class}), @Signature(name="removeStatementEventListener", args={StatementEventListener.class}), @Signature(name="setClientInfo", args={String.class, String.class}), @Signature(name="setClientInfo", args={Properties.class})})
    protected void preNoThrow(Method m, Object receiver, Object ... args) {
        try {
            this.pre(m, receiver, args);
        }
        catch (SQLException e) {
            throw new ProxyException(e);
        }
    }

    @Pre
    protected void pre(Method m, Object receiver, Object ... args) throws SQLException {
        UniversalPooledConnection upc = this.getUPC();
        assert (null != upc) : "upc shold be defined at this point";
        upc.heartbeat();
        if (this.closed.get()) {
            String msg = UCPErrorHandler.findSQLMessage(31);
            throw new SQLRecoverableException(msg, null, 31);
        }
    }

    private void setDefaultQueryTimeout(Statement statement) {
        int queryTimeout = ((UniversalConnectionPoolBase)this.getUCP()).getQueryTimeout();
        if (queryTimeout > 0) {
            try {
                statement.setQueryTimeout(queryTimeout);
            }
            catch (SQLException e) {
                this.trace(Level.WARNING, CLASS_NAME, "setDefaultQueryTimeout", "", null, e, new Object[0]);
            }
        }
    }

    @Post
    @Methods(signatures={@Signature(name="createStatement", args={}), @Signature(name="createStatement", args={int.class, int.class}), @Signature(name="createStatement", args={int.class, int.class, int.class})})
    protected Statement post(Method m, Statement result) {
        UniversalPooledConnection upc = this.getUPC();
        assert (null != upc) : "upc shold be defined at this point";
        upc.heartbeat();
        this.saveStatementProxy(result);
        this.setDefaultQueryTimeout(result);
        return result;
    }

    @Post
    @Methods(signatures={@Signature(name="prepareCall", args={String.class}), @Signature(name="prepareCall", args={String.class, int.class, int.class}), @Signature(name="prepareCall", args={String.class, int.class, int.class, int.class}), @Signature(name="prepareCall", args={String.class, Properties.class})})
    protected CallableStatement post(Method m, CallableStatement result) {
        UniversalPooledConnection upc = this.getUPC();
        assert (null != upc) : "upc shold be defined at this point";
        upc.heartbeat();
        this.saveStatementProxy(result);
        this.setDefaultQueryTimeout(result);
        return result;
    }

    @Post
    @Methods(signatures={@Signature(name="prepareStatement", args={String.class}), @Signature(name="prepareStatement", args={String.class, int.class}), @Signature(name="prepareStatement", args={String.class, int[].class}), @Signature(name="prepareStatement", args={String.class, int.class, int.class}), @Signature(name="prepareStatement", args={String.class, int.class, int.class, int.class}), @Signature(name="prepareStatement", args={String.class, String[].class})})
    protected PreparedStatement post(Method m, PreparedStatement result) {
        UniversalPooledConnection upc = this.getUPC();
        assert (null != upc) : "upc shold be defined at this point";
        upc.heartbeat();
        this.saveStatementProxy(result);
        this.setDefaultQueryTimeout(result);
        return result;
    }

    @Post
    protected Object postRest(Method m, Object result) {
        UniversalPooledConnection upc = this.getUPC();
        assert (null != upc) : "upc shold be defined at this point";
        upc.heartbeat();
        this.saveStatementProxy(result);
        return result;
    }

    @OnError(value=SQLException.class)
    protected void onSQLExceptionErrorVoid(Method m, SQLException e) throws SQLException {
        this.onSQLExceptionError(m, e);
    }

    @OnError(value=SQLException.class)
    protected Object onSQLExceptionError(Method m, SQLException e) throws SQLException {
        UniversalPooledConnection upc = this.getUPC();
        assert (null != upc) : "upc shold be defined at this point";
        upc.heartbeat();
        this.handleSQLRecoverableException(e);
        throw e;
    }

    @OnError(value=RuntimeException.class)
    protected void onRuntimeExceptionErrorVoid(Method m, RuntimeException e) throws RuntimeException {
        this.onRuntimeExceptionError(m, e);
    }

    @OnError(value=RuntimeException.class)
    protected Object onRuntimeExceptionError(Method m, RuntimeException e) throws RuntimeException {
        UniversalPooledConnection upc = this.getUPC();
        assert (null != upc) : "upc shold be defined at this point";
        upc.heartbeat();
        this.handleRuntimeException(e);
        throw e;
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public <T> T unwrap(Class<T> iface) throws SQLException {
        UniversalPooledConnection upc = this.getUPC();
        assert (null != upc) : "upc shold be defined at this point";
        upc.heartbeat();
        if (iface.isInterface()) {
            if (iface.isInstance(this.getDelegate())) {
                Connection t = this.getDelegate();
                return (T)t;
            }
            return this.getDelegate().unwrap(iface);
        }
        throw new SQLException("unable to unwrap interface " + iface.toString());
    }

    private void handleExceptionHelper() {
        if (!this.actuallyReturned.get()) {
            try {
                if (!this.statementsToClose.isEmpty()) {
                    try {
                        for (StatementProxy stmt : this.statementsToClose.toList()) {
                            stmt.close();
                        }
                    }
                    catch (Throwable t) {
                        this.trace(Level.WARNING, CLASS_NAME, "handleExceptionHelper", "", null, t, new Object[0]);
                    }
                    this.statementsToClose.clear();
                }
                UniversalPooledConnection upc = this.getUPC();
                assert (null != upc) : "upc shold be defined at this point";
                UniversalConnectionPool ucp = this.getUCP();
                assert (null != upc) : "ucp shold be defined at this point";
                try {
                    upc.setStatus(UniversalPooledConnectionStatus.STATUS_BAD);
                }
                catch (Throwable t) {
                    this.trace(Level.WARNING, CLASS_NAME, "handleExceptionHelper", "", null, t, new Object[0]);
                }
                ucp.returnConnection(upc);
                this.actuallyReturned.set(true);
                this.closed.set(true);
            }
            catch (UniversalConnectionPoolException ucpe) {
                this.trace(Level.WARNING, CLASS_NAME, "handleExceptionHelper", "", null, ucpe, new Object[0]);
            }
        }
    }

    protected void handleSQLRecoverableException(SQLException e) throws SQLException {
        if (e instanceof SQLRecoverableException) {
            this.handleExceptionHelper();
        }
    }

    protected void handleRuntimeException(RuntimeException e) throws RuntimeException {
        this.handleExceptionHelper();
    }

    @Override
    public void close() throws SQLException {
        UniversalPooledConnection upc = this.getUPC();
        assert (null != upc) : "upc shold be defined at this point";
        UniversalConnectionPool ucp = this.getUCP();
        assert (null != upc) : "ucp shold be defined at this point";
        upc.heartbeat();
        if (!this.closed.compareAndSet(false, true)) {
            return;
        }
        try {
            if (!this.statementsToClose.isEmpty()) {
                try {
                    for (StatementProxy stmt : this.statementsToClose.toList()) {
                        stmt.close();
                    }
                }
                catch (Throwable t) {
                    this.trace(Level.WARNING, CLASS_NAME, "close", "", null, t, new Object[0]);
                }
                this.statementsToClose.clear();
            }
            ucp.returnConnection(upc);
            this.actuallyReturned.set(true);
            upc.heartbeat();
        }
        catch (UniversalConnectionPoolException e) {
            Throwable cause = e.getCause();
            if (null == cause) {
                throw new SQLException(e);
            }
            Throwable cause2 = cause.getCause();
            if (null == cause2 || !(cause2 instanceof SQLException)) {
                throw new SQLException(e);
            }
            throw (SQLException)cause2;
        }
    }

    public boolean isValid(int timeout) throws SQLException {
        if (this.closed.get()) {
            return false;
        }
        return this.getDelegate().isValid(timeout);
    }

    @Override
    public boolean isValid() throws SQLException {
        if (this.closed.get()) {
            return false;
        }
        UniversalPooledConnection upc = this.getUPC();
        assert (null != upc) : "upc shold be defined at this point";
        return upc.isValid();
    }

    @Override
    public void setInvalid() throws SQLException {
        UniversalPooledConnection upc = this.getUPC();
        assert (null != upc) : "upc shold be defined at this point";
        upc.heartbeat();
        try {
            upc.setStatus(UniversalPooledConnectionStatus.STATUS_BAD);
        }
        catch (UniversalConnectionPoolException e) {
            throw new SQLException(e);
        }
    }

    public boolean isClosed() throws SQLException {
        if (this.closed.get()) {
            return true;
        }
        return this.getDelegate().isClosed();
    }

    @Override
    public boolean isLogicallyClosed() {
        return this.closed.get();
    }

    @Override
    public void applyConnectionLabel(String key, String value) throws SQLException {
        if (this.closed.get()) {
            throw UCPErrorHandler.newSQLException(31);
        }
        UniversalPooledConnection upc = this.getUPC();
        assert (null != upc) : "upc shold be defined at this point";
        try {
            upc.applyConnectionLabel(key, value);
        }
        catch (UniversalConnectionPoolException ucpExc) {
            UCPErrorHandler.throwSQLException(32, ucpExc);
        }
    }

    @Override
    public void removeConnectionLabel(String key) throws SQLException {
        if (this.closed.get()) {
            throw UCPErrorHandler.newSQLException(31);
        }
        UniversalPooledConnection upc = this.getUPC();
        assert (null != upc) : "upc shold be defined at this point";
        try {
            upc.removeConnectionLabel(key);
        }
        catch (UniversalConnectionPoolException ucpExc) {
            UCPErrorHandler.throwSQLException(33, ucpExc);
        }
    }

    @Override
    public Properties getConnectionLabels() throws SQLException {
        if (this.closed.get()) {
            throw UCPErrorHandler.newSQLException(31);
        }
        Properties props = null;
        UniversalPooledConnection upc = this.getUPC();
        assert (null != upc) : "upc shold be defined at this point";
        try {
            props = upc.getConnectionLabels();
        }
        catch (UniversalConnectionPoolException ucpExc) {
            UCPErrorHandler.throwSQLException(34, ucpExc);
        }
        return props;
    }

    @Override
    public Properties getUnmatchedConnectionLabels(Properties requestedLabels) throws SQLException {
        if (this.closed.get()) {
            throw UCPErrorHandler.newSQLException(31);
        }
        Properties props = null;
        UniversalPooledConnection upc = this.getUPC();
        assert (null != upc) : "upc shold be defined at this point";
        try {
            props = upc.getUnmatchedConnectionLabels(requestedLabels);
        }
        catch (UniversalConnectionPoolException ucpExc) {
            UCPErrorHandler.throwSQLException(35, ucpExc);
        }
        return props;
    }

    @Override
    public void setConnectionHarvestable(boolean isConnectionHarvestable) throws SQLException {
        if (this.closed.get()) {
            throw UCPErrorHandler.newSQLException(31);
        }
        UniversalPooledConnection upc = this.getUPC();
        assert (null != upc) : "upc shold be defined at this point";
        try {
            upc.setConnectionHarvestable(isConnectionHarvestable);
        }
        catch (UniversalConnectionPoolException ucpExc) {
            UCPErrorHandler.throwSQLException(36, ucpExc);
        }
    }

    @Override
    public boolean isConnectionHarvestable() throws SQLException {
        if (this.closed.get()) {
            throw UCPErrorHandler.newSQLException(31);
        }
        UniversalPooledConnection upc = this.getUPC();
        assert (null != upc) : "upc shold be defined at this point";
        return upc.isConnectionHarvestable();
    }

    @Override
    public void registerConnectionHarvestingCallback(ConnectionHarvestingCallback cbk) throws SQLException {
        if (this.closed.get()) {
            throw UCPErrorHandler.newSQLException(31);
        }
        UniversalPooledConnection upc = this.getUPC();
        assert (null != upc) : "upc shold be defined at this point";
        try {
            upc.registerConnectionHarvestingCallback(cbk);
        }
        catch (UniversalConnectionPoolException ucpExc) {
            UCPErrorHandler.throwSQLException(37, ucpExc);
        }
    }

    @Override
    public void removeConnectionHarvestingCallback() throws SQLException {
        if (this.closed.get()) {
            throw UCPErrorHandler.newSQLException(31);
        }
        UniversalPooledConnection upc = this.getUPC();
        assert (null != upc) : "upc shold be defined at this point";
        try {
            upc.removeConnectionHarvestingCallback();
        }
        catch (UniversalConnectionPoolException ucpExc) {
            UCPErrorHandler.throwSQLException(38, ucpExc);
        }
    }

    @Override
    public void registerAbandonedConnectionTimeoutCallback(AbandonedConnectionTimeoutCallback cbk) throws SQLException {
        if (this.closed.get()) {
            throw UCPErrorHandler.newSQLException(31);
        }
        UniversalPooledConnection upc = this.getUPC();
        assert (null != upc) : "upc shold be defined at this point";
        try {
            upc.registerAbandonedConnectionTimeoutCallback(cbk);
        }
        catch (UniversalConnectionPoolException ucpExc) {
            UCPErrorHandler.throwSQLException(39, ucpExc);
        }
    }

    @Override
    public void removeAbandonedConnectionTimeoutCallback() throws SQLException {
        if (this.closed.get()) {
            throw UCPErrorHandler.newSQLException(31);
        }
        UniversalPooledConnection upc = this.getUPC();
        assert (null != upc) : "upc shold be defined at this point";
        try {
            upc.removeAbandonedConnectionTimeoutCallback();
        }
        catch (UniversalConnectionPoolException ucpExc) {
            UCPErrorHandler.throwSQLException(40, ucpExc);
        }
    }

    @Override
    public void registerTimeToLiveConnectionTimeoutCallback(TimeToLiveConnectionTimeoutCallback cbk) throws SQLException {
        if (this.closed.get()) {
            throw UCPErrorHandler.newSQLException(31);
        }
        UniversalPooledConnection upc = this.getUPC();
        assert (null != upc) : "upc shold be defined at this point";
        try {
            upc.registerTimeToLiveConnectionTimeoutCallback(cbk);
        }
        catch (UniversalConnectionPoolException ucpExc) {
            UCPErrorHandler.throwSQLException(41, ucpExc);
        }
    }

    @Override
    public void removeTimeToLiveConnectionTimeoutCallback() throws SQLException {
        if (this.closed.get()) {
            throw UCPErrorHandler.newSQLException(31);
        }
        UniversalPooledConnection upc = this.getUPC();
        assert (null != upc) : "upc shold be defined at this point";
        try {
            upc.removeTimeToLiveConnectionTimeoutCallback();
        }
        catch (UniversalConnectionPoolException ucpExc) {
            UCPErrorHandler.throwSQLException(42, ucpExc);
        }
    }

    public boolean equals(Object thatObj) {
        if (null == thatObj) {
            return false;
        }
        if (this == thatObj) {
            return true;
        }
        return this.getDelegate().equals(thatObj instanceof ConnectionProxy ? ((ConnectionProxy)thatObj).getDelegate() : thatObj);
    }

    public int hashCode() {
        return this.getDelegate().hashCode();
    }

    protected void saveStatementProxy(Object result) {
        if (result instanceof StatementProxy) {
            StatementProxy statementProxy = (StatementProxy)result;
            statementProxy.setStatementChainAtom(this.statementsToClose.add(statementProxy));
        }
    }
}

