/*
 * Decompiled with CFR 0.152.
 */
package oracle.ons.rpc.impl;

import oracle.ons.CallBackMode;
import oracle.ons.ONS;
import oracle.ons.rpc.RpcRequest;
import oracle.ons.rpc.RpcRequestListener;
import oracle.ons.rpc.RpcServer;
import oracle.ons.rpc.RpcServerException;

public class RpcServerTest
implements RpcRequestListener {
    private String rpcServerName;
    private String compName;
    private String rpcCallBackName;

    RpcServerTest(String string, String string2, String string3) {
        this.rpcServerName = string;
        this.compName = string2;
        this.rpcCallBackName = string3;
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length != 3) {
            throw new Exception("Usage: java oracle.ons.rpc.impl.RpcServerTest <oracle_home_location> <rpc_server_name> <rpc_callback_name>");
        }
        ONS oNS = new ONS(1, stringArray[0]);
        RpcServerTest rpcServerTest = new RpcServerTest(stringArray[1], "/Component/RpcServerTest", stringArray[2]);
        rpcServerTest.doServer(oNS);
        oNS.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doServer(ONS oNS) throws RpcServerException {
        RpcServer rpcServer = oNS.createRpcServer(this.rpcServerName, this.compName, null, CallBackMode.SERIAL);
        rpcServer.addRequestListener(this.rpcCallBackName, this);
        rpcServer.launch();
        RpcServer rpcServer2 = oNS.createRpcServer(this.rpcServerName, this.compName, null, CallBackMode.SERIAL);
        rpcServer2.addRequestListener(this.rpcCallBackName, this);
        try {
            rpcServer2.launch();
            throw new RpcServerException("Registering rpc server " + this.rpcServerName + " should fail");
        }
        catch (RpcServerException rpcServerException) {
            System.out.println("Caught expected exception: " + rpcServerException.getMessage());
            System.out.println("Call shutdown on the second rpc server");
            rpcServer2.shutdown();
            RpcServerTest rpcServerTest = this;
            synchronized (rpcServerTest) {
                try {
                    this.wait();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            rpcServer.shutdown();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onRequest(RpcRequest rpcRequest) {
        String string = "NULL";
        byte[] byArray = rpcRequest.getArgBytes();
        if (byArray != null) {
            string = new String(byArray);
        }
        System.out.println("RPC Server " + this.rpcServerName + " received from RPC Client: '" + string + "'");
        byte[] byArray2 = "HelloWorld".getBytes();
        rpcRequest.sendResult(byArray2, true);
        RpcServerTest rpcServerTest = this;
        synchronized (rpcServerTest) {
            this.notify();
        }
    }
}

