/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.xa;

import java.sql.Connection;
import java.sql.SQLException;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import oracle.jdbc.internal.Monitor;
import oracle.jdbc.pool.OraclePooledConnection;
import oracle.jdbc.xa.OracleXAResource;

public abstract class OracleXAConnection
extends OraclePooledConnection
implements oracle.jdbc.datasource.OracleXAConnection {
    protected XAResource xaResource = null;

    public OracleXAConnection() throws XAException {
        this((Connection)null);
    }

    public OracleXAConnection(Connection pc) throws XAException {
        super(pc);
    }

    @Override
    public abstract XAResource getXAResource() throws SQLException;

    @Override
    public Connection getConnection() throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            Connection conn = super.getConnection();
            if (this.xaResource != null) {
                ((OracleXAResource)this.xaResource).setLogicalConnection(conn);
            }
            Connection connection = conn;
            return connection;
        }
    }

    boolean getAutoCommit() throws SQLException {
        return this.autoCommit;
    }

    void setAutoCommit(boolean value) throws SQLException {
        this.autoCommit = value;
    }
}

