/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.SQLException;
import oracle.jdbc.driver.Binder;
import oracle.jdbc.driver.ByteArray;
import oracle.jdbc.driver.OraclePreparedStatement;
import oracle.jdbc.driver.SimpleByteArray;
import oracle.jdbc.driver.VectorCopyingBinder;
import oracle.jdbc.driver.VectorData;

final class VectorBinder<T>
extends Binder {
    private T values;
    private final VectorData.Encoder<? super T> encoder;
    private final boolean isComputingNorm;
    Binder copyingBinder;

    VectorBinder(T values, int vectorType, boolean isComputingNorm) throws SQLException {
        this.values = values;
        this.type = (short)127;
        this.isComputingNorm = isComputingNorm;
        Class<?> valuesClass = values.getClass();
        this.encoder = VectorData.getEncoder(valuesClass, vectorType);
        this.bytelen = this.encoder.getByteLength(values);
    }

    @Override
    long bind(OraclePreparedStatement stmt, int bindPosition, int rankInBuffer, int rank, byte[] bindBytes, char[] bindChars, short[] bindIndicators, int bytePitch, int charPitch, int byteoffset, int charoffset, int lenoffset, int indoffset, boolean clearPriorBindValues, long localCheckSum, ByteArray bindData, long[] bindDataOffsets, int[] bindDataLengths, int bindDataIndex, boolean bindUseDBA, int formOfUse) throws SQLException {
        ByteArray bindBuffer;
        long dataOffset;
        if (bindUseDBA) {
            stmt.lastBoundDataOffsets[bindPosition] = dataOffset = bindData.getPosition();
            bindDataOffsets[bindDataIndex] = dataOffset;
            bindBuffer = bindData;
        } else {
            dataOffset = 0L;
            bindBuffer = new SimpleByteArray(stmt.getDiagnosable(), bindBytes);
            bindBuffer.setPosition(byteoffset);
        }
        this.encoder.encode(this.values, this.isComputingNorm, bindBuffer);
        int length = (int)(bindBuffer.getPosition() - dataOffset);
        bindIndicators[indoffset] = 0;
        bindIndicators[lenoffset] = (short)Math.min(length, Short.MAX_VALUE);
        if (bindUseDBA) {
            bindDataLengths[bindDataIndex] = length;
            stmt.lastBoundDataLengths[bindPosition] = length;
        }
        if (clearPriorBindValues) {
            this.clearValue();
        }
        return localCheckSum;
    }

    void clearValue() {
        this.values = null;
    }

    @Override
    Binder copyingBinder() {
        if (this.copyingBinder == null) {
            this.copyingBinder = new VectorCopyingBinder(this);
        }
        return this.copyingBinder;
    }
}

