/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.sql.SQLException;
import oracle.jdbc.driver.DBConversion;
import oracle.jdbc.driver.NTFAQEvent;
import oracle.jdbc.driver.T4CMAREngine;
import oracle.jdbc.internal.KeywordValueLong;

final class KeywordValueLongI
extends KeywordValueLong {
    private int keyword;
    private String textValue;
    private byte[] textValueArr;
    private byte[] binaryValue;

    KeywordValueLongI(int _keyword, String _textValue, byte[] _binaryValue) {
        this.keyword = _keyword;
        this.textValue = _textValue;
        this.binaryValue = _binaryValue;
        this.textValueArr = null;
    }

    void doCharConversion(DBConversion conv) throws SQLException {
        this.textValueArr = (byte[])(this.textValue != null ? conv.StringToCharBytes(this.textValue) : null);
    }

    @Override
    public byte[] getBinaryValue() throws SQLException {
        return this.binaryValue;
    }

    @Override
    public String getTextValue() throws SQLException {
        return this.textValue;
    }

    @Override
    public int getKeyword() throws SQLException {
        return this.keyword;
    }

    void marshal(T4CMAREngine mar) throws IOException {
        if (this.textValueArr != null) {
            mar.marshalUB4(this.textValueArr.length);
            mar.marshalCLR(this.textValueArr, this.textValueArr.length);
            mar.marshalUB4(0L);
        } else {
            mar.marshalUB4(0L);
            if (this.binaryValue != null) {
                mar.marshalUB4(this.binaryValue.length);
                mar.marshalCLR(this.binaryValue, this.binaryValue.length);
            } else {
                mar.marshalUB4(0L);
            }
        }
        mar.marshalUB2(this.keyword);
    }

    static KeywordValueLongI unmarshal(T4CMAREngine mar) throws SQLException, IOException {
        int kpdkvlbl;
        int[] intArr = new int[1];
        String kpdkvlcv = null;
        byte[] kpdkvlbv = null;
        int kpdkvlcl = (int)mar.unmarshalUB4();
        if (kpdkvlcl != 0) {
            byte[] textValueArr = new byte[kpdkvlcl];
            mar.unmarshalCLR(textValueArr, 0, intArr);
            kpdkvlcv = mar.conv.CharBytesToString(textValueArr, intArr[0]);
        }
        if ((kpdkvlbl = (int)mar.unmarshalUB4()) != 0) {
            kpdkvlbv = new byte[kpdkvlbl];
            mar.unmarshalCLR(kpdkvlbv, 0, intArr);
        }
        int kpdkvlk = mar.unmarshalUB2();
        return new KeywordValueLongI(kpdkvlk, kpdkvlcv, kpdkvlbv);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("keyword    : " + this.keyword + "\n");
        sb.append("text value : " + this.textValue + "\n");
        if (this.binaryValue == null) {
            sb.append("bin value  : null\n");
        } else {
            sb.append("bin value  : " + NTFAQEvent.byteBufferToHexString(this.binaryValue, 50) + "\n");
        }
        return sb.toString();
    }
}

