/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.da.comp.writer2latex;

import com.sun.star.beans.PropertyValue;
import com.sun.star.document.XExtendedFilterDetection;
import com.sun.star.io.XInputStream;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.XServiceInfo;
import com.sun.star.lib.uno.adapter.XInputStreamToInputStreamAdapter;
import com.sun.star.lib.uno.helper.WeakBase;
import com.sun.star.ucb.CommandAbortedException;
import com.sun.star.ucb.XSimpleFileAccess2;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XComponentContext;
import java.io.IOException;
import java.io.InputStream;
import org.openoffice.da.comp.writer2latex.DeTeXtive;

public class TeXDetectService
extends WeakBase
implements XExtendedFilterDetection,
XServiceInfo {
    public static final String __implementationName = TeXDetectService.class.getName();
    public static final String __serviceName = "com.sun.star.document.ExtendedTypeDetection";
    private static final String[] m_serviceNames = new String[]{"com.sun.star.document.ExtendedTypeDetection"};
    private static final String LATEX_FILE = "org.openoffice.da.writer2latex.LaTeX_File";
    private static final String XELATEX_FILE = "org.openoffice.da.writer2latex.XeLaTeX_File";
    private final XComponentContext m_xContext;

    public TeXDetectService(XComponentContext xContext) {
        this.m_xContext = xContext;
    }

    public String getImplementationName() {
        return __implementationName;
    }

    public boolean supportsService(String sService) {
        int len = m_serviceNames.length;
        for (int i = 0; i < len; ++i) {
            if (!sService.equals(m_serviceNames[i])) continue;
            return true;
        }
        return false;
    }

    public String[] getSupportedServiceNames() {
        return m_serviceNames;
    }

    public String detect(PropertyValue[][] mediaDescriptor) {
        String sURL = null;
        String sTypeName = null;
        if (mediaDescriptor.length > 0) {
            int nLength = mediaDescriptor[0].length;
            for (int i = 0; i < nLength; ++i) {
                try {
                    if (mediaDescriptor[0][i].Name.equals("URL")) {
                        sURL = AnyConverter.toString((Object)mediaDescriptor[0][i].Value);
                        continue;
                    }
                    if (!mediaDescriptor[0][i].Name.equals("TypeName")) continue;
                    sTypeName = AnyConverter.toString((Object)mediaDescriptor[0][i].Value);
                    continue;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        }
        if (sURL == null) {
            return "";
        }
        if (sTypeName == null || !sTypeName.equals(LATEX_FILE) && !sTypeName.equals(XELATEX_FILE)) {
            return "";
        }
        XSimpleFileAccess2 sfa2 = null;
        try {
            Object sfaObject = this.m_xContext.getServiceManager().createInstanceWithContext("com.sun.star.ucb.SimpleFileAccess", this.m_xContext);
            sfa2 = (XSimpleFileAccess2)UnoRuntime.queryInterface(XSimpleFileAccess2.class, (Object)sfaObject);
        }
        catch (Exception e) {
            return "";
        }
        XInputStreamToInputStreamAdapter is = null;
        try {
            XInputStream xis = sfa2.openFileRead(sURL);
            is = new XInputStreamToInputStreamAdapter(xis);
        }
        catch (CommandAbortedException e) {
            return "";
        }
        catch (Exception e) {
            return "";
        }
        DeTeXtive deTeXtive = new DeTeXtive();
        try {
            String sType = deTeXtive.deTeXt((InputStream)is);
            if ("LaTeX".equals(sType)) {
                return LATEX_FILE;
            }
            if ("XeLaTeX".equals(sType)) {
                return XELATEX_FILE;
            }
            return "";
        }
        catch (IOException e) {
            return "";
        }
    }
}

