/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.lower.coroutines;

import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.expressions.IrBreakContinue;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrReturn;
import org.jetbrains.kotlin.ir.symbols.IrReturnableBlockSymbol;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.visitors.IrVisitorVoid;
import org.jetbrains.kotlin.ir.visitors.IrVisitorsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0004H\u0002J\u0010\u0010\f\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\u0004H\u0002J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u0004H\u0016J\u0010\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0016H\u0016R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/coroutines/SuspendableNodesCollector;", "Lorg/jetbrains/kotlin/ir/visitors/IrVisitorVoid;", "suspendableNodes", "", "Lorg/jetbrains/kotlin/ir/IrElement;", "<init>", "(Ljava/util/Set;)V", "hasSuspendableChildren", "", "markNode", "", "node", "isSuspendableNode", "visitElement", "element", "visitCall", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "visitBreakContinue", "jump", "Lorg/jetbrains/kotlin/ir/expressions/IrBreakContinue;", "visitReturn", "Lorg/jetbrains/kotlin/ir/expressions/IrReturn;", "backend.js"})
public class SuspendableNodesCollector
extends IrVisitorVoid {
    @NotNull
    private final Set<IrElement> suspendableNodes;
    private boolean hasSuspendableChildren;

    public SuspendableNodesCollector(@NotNull Set<IrElement> suspendableNodes) {
        Intrinsics.checkNotNullParameter(suspendableNodes, "suspendableNodes");
        this.suspendableNodes = suspendableNodes;
    }

    private final void markNode(IrElement node) {
        ((Collection)this.suspendableNodes).add(node);
        this.hasSuspendableChildren = true;
    }

    private final boolean isSuspendableNode(IrElement node) {
        return this.suspendableNodes.contains(node);
    }

    @Override
    public void visitElement(@NotNull IrElement element) {
        Intrinsics.checkNotNullParameter(element, "element");
        boolean current = this.hasSuspendableChildren;
        this.hasSuspendableChildren = false;
        IrVisitorsKt.acceptChildrenVoid(element, this);
        if (this.hasSuspendableChildren) {
            this.markNode(element);
        }
        this.hasSuspendableChildren = this.hasSuspendableChildren || current;
    }

    @Override
    public void visitCall(@NotNull IrCall expression2) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        super.visitCall(expression2);
        if (IrUtilsKt.isSuspend(expression2)) {
            this.markNode(expression2);
        }
    }

    @Override
    public void visitBreakContinue(@NotNull IrBreakContinue jump) {
        Intrinsics.checkNotNullParameter(jump, "jump");
        if (this.isSuspendableNode(jump.getLoop())) {
            this.markNode(jump);
        }
    }

    @Override
    public void visitReturn(@NotNull IrReturn expression2) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        super.visitReturn(expression2);
        if (expression2.getReturnTargetSymbol() instanceof IrReturnableBlockSymbol && this.isSuspendableNode(expression2.getReturnTargetSymbol().getOwner())) {
            this.markNode(expression2);
        }
    }
}

