/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.extra;

import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import org.jetbrains.kotlin.fir.references.FirReferenceUtilsKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeUtilsKt;
import org.jetbrains.kotlin.name.CallableId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.name.StandardClassIds;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J-\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0002H\u0016R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\rJ\u000e\u0010\u000e\u001a\u0004\u0018\u00010\u000f*\u00020\u0002H\u0002R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/extra/UselessCallOnNotNullChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirQualifiedAccessExpression;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirQualifiedAccessExpressionChecker;", "<init>", "()V", "check", "", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "expression", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/expressions/FirQualifiedAccessExpression;)V", "getCallableId", "Lorg/jetbrains/kotlin/name/CallableId;", "triggerOn", "", "checkers"})
public final class UselessCallOnNotNullChecker
extends FirExpressionChecker<FirQualifiedAccessExpression> {
    @NotNull
    public static final UselessCallOnNotNullChecker INSTANCE = new UselessCallOnNotNullChecker();
    @NotNull
    private static final Set<CallableId> triggerOn;

    private UselessCallOnNotNullChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter, @NotNull FirQualifiedAccessExpression expression2) {
        Intrinsics.checkNotNullParameter(context2, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        Intrinsics.checkNotNullParameter(expression2, "expression");
        CallableId callableId = this.getCallableId(expression2);
        if (callableId == null) {
            return;
        }
        CallableId method = callableId;
        if (!triggerOn.contains(method)) {
            return;
        }
        FirExpression firExpression = expression2.getExplicitReceiver();
        if (firExpression == null) {
            return;
        }
        FirExpression calleeOn = firExpression;
        if (!TypeUtilsKt.canBeNull$default(FirTypeUtilsKt.getResolvedType(calleeOn), context2.getSession(), false, 2, null)) {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)expression2.getSource(), FirErrors.INSTANCE.getUSELESS_CALL_ON_NOT_NULL(), null, 8, null);
        }
    }

    private final CallableId getCallableId(FirQualifiedAccessExpression $this$getCallableId) {
        FirNamedFunctionSymbol firNamedFunctionSymbol = FirReferenceUtilsKt.toResolvedNamedFunctionSymbol$default($this$getCallableId.getCalleeReference(), false, 1, null);
        return firNamedFunctionSymbol != null ? firNamedFunctionSymbol.getCallableId() : null;
    }

    static {
        CallableId[] callableIdArray = new CallableId[8];
        FqName fqName = StandardClassIds.INSTANCE.getBASE_COLLECTIONS_PACKAGE();
        Name name2 = Name.identifier("orEmpty");
        Intrinsics.checkNotNullExpressionValue(name2, "identifier(...)");
        callableIdArray[0] = new CallableId(fqName, name2);
        FqName fqName2 = StandardClassIds.INSTANCE.getBASE_SEQUENCES_PACKAGE();
        Name name3 = Name.identifier("orEmpty");
        Intrinsics.checkNotNullExpressionValue(name3, "identifier(...)");
        callableIdArray[1] = new CallableId(fqName2, name3);
        FqName fqName3 = StandardClassIds.INSTANCE.getBASE_TEXT_PACKAGE();
        Name name4 = Name.identifier("orEmpty");
        Intrinsics.checkNotNullExpressionValue(name4, "identifier(...)");
        callableIdArray[2] = new CallableId(fqName3, name4);
        FqName fqName4 = StandardClassIds.INSTANCE.getBASE_KOTLIN_PACKAGE();
        Name name5 = Name.identifier("orEmpty");
        Intrinsics.checkNotNullExpressionValue(name5, "identifier(...)");
        callableIdArray[3] = new CallableId(fqName4, name5);
        FqName fqName5 = StandardClassIds.INSTANCE.getBASE_TEXT_PACKAGE();
        Name name6 = Name.identifier("isNullOrBlank");
        Intrinsics.checkNotNullExpressionValue(name6, "identifier(...)");
        callableIdArray[4] = new CallableId(fqName5, name6);
        FqName fqName6 = StandardClassIds.INSTANCE.getBASE_TEXT_PACKAGE();
        Name name7 = Name.identifier("isNullOrEmpty");
        Intrinsics.checkNotNullExpressionValue(name7, "identifier(...)");
        callableIdArray[5] = new CallableId(fqName6, name7);
        FqName fqName7 = StandardClassIds.INSTANCE.getBASE_KOTLIN_PACKAGE();
        Name name8 = Name.identifier("isNullOrBlank");
        Intrinsics.checkNotNullExpressionValue(name8, "identifier(...)");
        callableIdArray[6] = new CallableId(fqName7, name8);
        FqName fqName8 = StandardClassIds.INSTANCE.getBASE_KOTLIN_PACKAGE();
        Name name9 = Name.identifier("isNullOrEmpty");
        Intrinsics.checkNotNullExpressionValue(name9, "identifier(...)");
        callableIdArray[7] = new CallableId(fqName8, name9);
        triggerOn = SetsKt.setOf(callableIdArray);
    }
}

