/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.config;

import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.AnalysisFlags;
import org.jetbrains.kotlin.config.WarningLevel;
import org.jetbrains.kotlin.diagnostics.AbstractKtDiagnosticFactory;
import org.jetbrains.kotlin.diagnostics.Severity;
import org.jetbrains.kotlin.diagnostics.impl.BaseDiagnosticsCollector;
import org.jetbrains.kotlin.fir.FirLanguageSettingsComponentKt;
import org.jetbrains.kotlin.fir.analysis.checkers.config.FirLanguageVersionSettingsChecker;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirComposedDiagnosticRendererFactoryKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J!\u0010\u0004\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\tH\u0016R\u00020\u0006j\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\n\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/config/FirSuppressedDiagnosticsCheckers;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/config/FirLanguageVersionSettingsChecker;", "<init>", "()V", "check", "", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "reporter", "Lorg/jetbrains/kotlin/diagnostics/impl/BaseDiagnosticsCollector$RawReporter;", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/impl/BaseDiagnosticsCollector$RawReporter;)V", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirSuppressedDiagnosticsCheckers.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirSuppressedDiagnosticsCheckers.kt\norg/jetbrains/kotlin/fir/analysis/checkers/config/FirSuppressedDiagnosticsCheckers\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,35:1\n1208#2,2:36\n1236#2,4:38\n*S KotlinDebug\n*F\n+ 1 FirSuppressedDiagnosticsCheckers.kt\norg/jetbrains/kotlin/fir/analysis/checkers/config/FirSuppressedDiagnosticsCheckers\n*L\n21#1:36,2\n21#1:38,4\n*E\n"})
public final class FirSuppressedDiagnosticsCheckers
extends FirLanguageVersionSettingsChecker {
    @NotNull
    public static final FirSuppressedDiagnosticsCheckers INSTANCE = new FirSuppressedDiagnosticsCheckers();

    private FirSuppressedDiagnosticsCheckers() {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void check(@NotNull CheckerContext context2, @NotNull BaseDiagnosticsCollector.RawReporter reporter) {
        void $this$associateByTo$iv$iv;
        Intrinsics.checkNotNullParameter(context2, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        Map<String, WarningLevel> warningLevelMap = FirLanguageSettingsComponentKt.getLanguageVersionSettings(context2.getSession()).getFlag(AnalysisFlags.INSTANCE.getWarningLevels());
        if (warningLevelMap.isEmpty()) {
            return;
        }
        Iterable $this$associateBy$iv = FirComposedDiagnosticRendererFactoryKt.getDiagnosticRendererFactory(context2.getSession()).getAllDiagnosticFactories();
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($this$associateBy$iv, 10)), 16);
        Iterable iterable = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            AbstractKtDiagnosticFactory abstractKtDiagnosticFactory = (AbstractKtDiagnosticFactory)element$iv$iv;
            Map map = destination$iv$iv;
            boolean bl = false;
            map.put(it.getName(), element$iv$iv);
        }
        Map allDiagnosticFactories = destination$iv$iv;
        for (String diagnosticName : warningLevelMap.keySet()) {
            AbstractKtDiagnosticFactory diagnosticFactory = (AbstractKtDiagnosticFactory)allDiagnosticFactories.get(diagnosticName);
            if (diagnosticFactory == null) {
                reporter.reportError("Warning with name \"" + diagnosticName + "\" does not exist");
                continue;
            }
            if (diagnosticFactory.getSeverity() != Severity.ERROR) continue;
            reporter.reportError("Diagnostic \"" + diagnosticName + "\" is an error. Changing the severity of errors is prohibited");
        }
    }
}

