/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.text;

import com.intellij.openapi.util.text.CharSequenceWithStringHash;
import com.intellij.openapi.util.text.Strings;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.util.text.CharSequenceBackedByArray;
import org.jetbrains.annotations.NotNull;

public class CharArrayCharSequence
implements CharSequenceWithStringHash,
CharSequenceBackedByArray {
    protected final char[] myChars;
    protected final int myStart;
    protected final int myEnd;
    private transient int hash;

    public CharArrayCharSequence(char ... chars) {
        if (chars == null) {
            CharArrayCharSequence.$$$reportNull$$$0(0);
        }
        this(chars, 0, chars.length);
    }

    public CharArrayCharSequence(char @NotNull [] chars, int start, int end) {
        if (chars == null) {
            CharArrayCharSequence.$$$reportNull$$$0(1);
        }
        if (start < 0 || end > chars.length || start > end) {
            throw new IndexOutOfBoundsException("chars.length:" + chars.length + ", start:" + start + ", end:" + end);
        }
        this.myChars = chars;
        this.myStart = start;
        this.myEnd = end;
    }

    @Override
    public final int length() {
        return this.myEnd - this.myStart;
    }

    @Override
    public final char charAt(int index) {
        return this.myChars[index + this.myStart];
    }

    @Override
    @NotNull
    public CharSequence subSequence(int start, int end) {
        return start == 0 && end == this.length() ? this : new CharArrayCharSequence(this.myChars, this.myStart + start, this.myStart + end);
    }

    @Override
    @NotNull
    public String toString() {
        return new String(this.myChars, this.myStart, this.myEnd - this.myStart);
    }

    @Override
    public char @NotNull [] getChars() {
        if (this.myStart == 0) {
            if (this.myChars == null) {
                CharArrayCharSequence.$$$reportNull$$$0(2);
            }
            return this.myChars;
        }
        char[] chars = new char[this.length()];
        this.getChars(chars, 0);
        if (chars == null) {
            CharArrayCharSequence.$$$reportNull$$$0(3);
        }
        return chars;
    }

    @Override
    public void getChars(char @NotNull [] dst, int dstOffset) {
        if (dst == null) {
            CharArrayCharSequence.$$$reportNull$$$0(4);
        }
        System.arraycopy(this.myChars, this.myStart, dst, dstOffset, this.length());
    }

    public boolean equals(Object anObject) {
        if (this == anObject) {
            return true;
        }
        if (anObject == null || this.getClass() != anObject.getClass() || this.length() != ((CharSequence)anObject).length()) {
            return false;
        }
        return CharArrayUtil.regionMatches(this.myChars, this.myStart, this.myEnd, (CharSequence)anObject);
    }

    public int hashCode() {
        int h2 = this.hash;
        if (h2 == 0) {
            this.hash = h2 = Strings.stringHashCode(this.myChars, this.myStart, this.myEnd);
        }
        return h2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 2: 
            case 3: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chars";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/text/CharArrayCharSequence";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dst";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/text/CharArrayCharSequence";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getChars";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getChars";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

