/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io.pagecache.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.io.DirectByteBufferAllocator;
import com.intellij.util.io.pagecache.FilePageCacheStatistics;
import com.intellij.util.io.pagecache.impl.IMemoryManager;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicLong;
import org.jetbrains.annotations.NotNull;

public final class DefaultMemoryManager
implements IMemoryManager {
    private static final Logger LOG = Logger.getInstance(DefaultMemoryManager.class);
    private final long nativeCapacityBytes;
    private final long heapCapacityBytes;
    private final AtomicLong nativeBytesUsed;
    private final AtomicLong heapBytesUsed;
    private final DirectByteBufferAllocator directBufferAllocator;
    @NotNull
    private final FilePageCacheStatistics statistics;

    /*
     * WARNING - void declaration
     */
    public DefaultMemoryManager(long nativeCapacityBytes, long heapCapacityBytes, @NotNull FilePageCacheStatistics filePageCacheStatistics) {
        void statistics;
        if (filePageCacheStatistics == null) {
            DefaultMemoryManager.$$$reportNull$$$0(0);
        }
        this.nativeBytesUsed = new AtomicLong(0L);
        this.heapBytesUsed = new AtomicLong(0L);
        this.directBufferAllocator = DirectByteBufferAllocator.ALLOCATOR;
        if (nativeCapacityBytes <= 0L) {
            throw new IllegalArgumentException("nativeCapacityBytes(=" + nativeCapacityBytes + ") must be >0");
        }
        if (heapCapacityBytes <= 0L) {
            throw new IllegalArgumentException("heapCapacityBytes(=" + heapCapacityBytes + ") must be >0");
        }
        this.nativeCapacityBytes = nativeCapacityBytes;
        this.heapCapacityBytes = heapCapacityBytes;
        this.statistics = statistics;
    }

    @Override
    public void releaseBuffer(int bufferSize, @NotNull ByteBuffer buffer) {
        if (buffer == null) {
            DefaultMemoryManager.$$$reportNull$$$0(1);
        }
        if (buffer.isDirect()) {
            this.directBufferAllocator.release(buffer);
            long memoryUsed = this.nativeBytesUsed.addAndGet(-bufferSize);
            if (memoryUsed < 0L) {
                throw new IllegalStateException("nativeBytesUsed(=" + memoryUsed + ") must be >=0");
            }
            this.statistics.pageReclaimedNative(bufferSize);
        } else {
            long memoryUsed = this.heapBytesUsed.addAndGet(-bufferSize);
            if (memoryUsed < 0L) {
                throw new IllegalStateException("heapBytesUsed(=" + memoryUsed + ") must be >=0");
            }
            this.statistics.pageReclaimedHeap(bufferSize);
        }
    }

    @Override
    public boolean hasOverflow() {
        return this.totalMemoryUsed() > this.nativeCapacityBytes;
    }

    @Override
    public long nativeBytesUsed() {
        return this.nativeBytesUsed.get();
    }

    @Override
    public long heapBytesUsed() {
        return this.heapBytesUsed.get();
    }

    @Override
    public long nativeCapacityBytes() {
        return this.nativeCapacityBytes;
    }

    public String toString() {
        return "DefaultMemoryManager{nativeCapacity: " + this.nativeCapacityBytes + ", heapCapacity: " + this.heapCapacityBytes + ", nativeUsed: " + this.nativeBytesUsed + ", heapUsed: " + this.heapBytesUsed + '}';
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statistics";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buffer";
                break;
            }
        }
        objectArray2[1] = "com/intellij/util/io/pagecache/impl/DefaultMemoryManager";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "releaseBuffer";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

